/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import reactor.core.publisher.Mono;

public final class InMemoryReactiveClientRegistrationRepository
implements ReactiveClientRegistrationRepository,
Iterable<ClientRegistration> {
    private final Map<String, ClientRegistration> clientIdToClientRegistration;

    public InMemoryReactiveClientRegistrationRepository(ClientRegistration ... registrations) {
        Assert.notEmpty((Object[])registrations, (String)"registrations cannot be empty");
        this.clientIdToClientRegistration = new ConcurrentReferenceHashMap();
        for (ClientRegistration registration : registrations) {
            Assert.notNull((Object)registration, (String)"registrations cannot contain null values");
            this.clientIdToClientRegistration.put(registration.getRegistrationId(), registration);
        }
    }

    public InMemoryReactiveClientRegistrationRepository(List<ClientRegistration> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be null or empty");
        this.clientIdToClientRegistration = registrations.stream().collect(Collectors.toConcurrentMap(ClientRegistration::getRegistrationId, Function.identity()));
    }

    @Override
    public Mono<ClientRegistration> findByRegistrationId(String registrationId) {
        return Mono.justOrEmpty((Object)this.clientIdToClientRegistration.get(registrationId));
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.clientIdToClientRegistration.values().iterator();
    }
}

