/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.ReactiveOidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OidcAuthorizationCodeReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private static final String INVALID_STATE_PARAMETER_ERROR_CODE = "invalid_state_parameter";
    private static final String INVALID_REDIRECT_URI_PARAMETER_ERROR_CODE = "invalid_redirect_uri_parameter";
    private static final String INVALID_ID_TOKEN_ERROR_CODE = "invalid_id_token";
    private static final String INVALID_NONCE_ERROR_CODE = "invalid_nonce";
    private final ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;
    private final ReactiveOAuth2UserService<OidcUserRequest, OidcUser> userService;
    private GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;
    private ReactiveJwtDecoderFactory<ClientRegistration> jwtDecoderFactory = new ReactiveOidcIdTokenDecoderFactory();

    public OidcAuthorizationCodeReactiveAuthenticationManager(ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, ReactiveOAuth2UserService<OidcUserRequest, OidcUser> userService) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        Assert.notNull(userService, (String)"userService cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
        this.userService = userService;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.defer(() -> {
            OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
            if (!authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest().getScopes().contains("openid")) {
                return Mono.empty();
            }
            OAuth2AuthorizationRequest authorizationRequest = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest();
            OAuth2AuthorizationResponse authorizationResponse = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationResponse();
            if (authorizationResponse.statusError()) {
                throw new OAuth2AuthenticationException(authorizationResponse.getError(), authorizationResponse.getError().toString());
            }
            if (!authorizationResponse.getState().equals(authorizationRequest.getState())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_STATE_PARAMETER_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            if (!authorizationResponse.getRedirectUri().equals(authorizationRequest.getRedirectUri())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_REDIRECT_URI_PARAMETER_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            OAuth2AuthorizationCodeGrantRequest authzRequest = new OAuth2AuthorizationCodeGrantRequest(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange());
            return this.accessTokenResponseClient.getTokenResponse(authzRequest).flatMap(accessTokenResponse -> this.authenticationResult(authorizationCodeAuthentication, (OAuth2AccessTokenResponse)accessTokenResponse)).onErrorMap(OAuth2AuthorizationException.class, e -> new OAuth2AuthenticationException(e.getError(), e.getError().toString())).onErrorMap(JwtException.class, e -> {
                OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, e.getMessage(), null);
                throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString(), (Throwable)e);
            });
        });
    }

    public final void setJwtDecoderFactory(ReactiveJwtDecoderFactory<ClientRegistration> jwtDecoderFactory) {
        Assert.notNull(jwtDecoderFactory, (String)"jwtDecoderFactory cannot be null");
        this.jwtDecoderFactory = jwtDecoderFactory;
    }

    private Mono<OAuth2LoginAuthenticationToken> authenticationResult(OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication, OAuth2AccessTokenResponse accessTokenResponse) {
        OAuth2AccessToken accessToken = accessTokenResponse.getAccessToken();
        ClientRegistration clientRegistration = authorizationCodeAuthentication.getClientRegistration();
        Map additionalParameters = accessTokenResponse.getAdditionalParameters();
        if (!additionalParameters.containsKey("id_token")) {
            OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Missing (required) ID Token in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), null);
            throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString());
        }
        return this.createOidcToken(clientRegistration, accessTokenResponse).doOnNext(idToken -> OidcAuthorizationCodeReactiveAuthenticationManager.validateNonce(authorizationCodeAuthentication, idToken)).map(idToken -> new OidcUserRequest(clientRegistration, accessToken, (OidcIdToken)idToken, additionalParameters)).flatMap(this.userService::loadUser).map(oauth2User -> {
            Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oauth2User.getAuthorities());
            return new OAuth2LoginAuthenticationToken(authorizationCodeAuthentication.getClientRegistration(), authorizationCodeAuthentication.getAuthorizationExchange(), (OAuth2User)oauth2User, mappedAuthorities, accessToken, accessTokenResponse.getRefreshToken());
        });
    }

    private Mono<OidcIdToken> createOidcToken(ClientRegistration clientRegistration, OAuth2AccessTokenResponse accessTokenResponse) {
        ReactiveJwtDecoder jwtDecoder = this.jwtDecoderFactory.createDecoder((Object)clientRegistration);
        String rawIdToken = (String)accessTokenResponse.getAdditionalParameters().get("id_token");
        return jwtDecoder.decode(rawIdToken).map(jwt -> new OidcIdToken(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getClaims()));
    }

    private static Mono<OidcIdToken> validateNonce(OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication, OidcIdToken idToken) {
        String requestNonce = (String)authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest().getAttribute("nonce");
        if (requestNonce != null) {
            String nonceHash;
            try {
                nonceHash = OidcAuthorizationCodeReactiveAuthenticationManager.createHash(requestNonce);
            }
            catch (NoSuchAlgorithmException e) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_NONCE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            String nonceHashClaim = idToken.getNonce();
            if (nonceHashClaim == null || !nonceHashClaim.equals(nonceHash)) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_NONCE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
        }
        return Mono.just((Object)idToken);
    }

    static String createHash(String nonce) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(nonce.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

