/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SingleKeyJWSKeySelector;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderProviderConfigurationUtils;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public final class NimbusJwtDecoder
implements JwtDecoder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String DECODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to decode the Jwt: %s";
    private final JWTProcessor<SecurityContext> jwtProcessor;
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();

    public NimbusJwtDecoder(JWTProcessor<SecurityContext> jwtProcessor) {
        Assert.notNull(jwtProcessor, (String)"jwtProcessor cannot be null");
        this.jwtProcessor = jwtProcessor;
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    public void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof PlainJWT) {
            this.logger.trace((Object)"Failed to decode unsigned token");
            throw new BadJwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
        }
        Jwt createdJwt = this.createJwt(token, jwt);
        return this.validateJwt(createdJwt);
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            this.logger.trace((Object)"Failed to parse token", (Throwable)ex);
            if (ex instanceof ParseException) {
                throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed token"), ex);
            }
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
    }

    private Jwt createJwt(String token, JWT parsedJwt) {
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            return Jwt.withTokenValue(token).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
        }
        catch (RemoteKeySourceException ex) {
            this.logger.trace((Object)"Failed to retrieve JWK set", (Throwable)ex);
            if (ex.getCause() instanceof ParseException) {
                throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed Jwk set"), ex);
            }
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        catch (JOSEException ex) {
            this.logger.trace((Object)"Failed to process JWT", (Throwable)ex);
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        catch (Exception ex) {
            this.logger.trace((Object)"Failed to process JWT", (Throwable)ex);
            if (ex.getCause() instanceof ParseException) {
                throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed payload"), ex);
            }
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
    }

    private Jwt validateJwt(Jwt jwt) {
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((OAuth2Token)jwt);
        if (result.hasErrors()) {
            Collection errors = result.getErrors();
            String validationErrorString = this.getJwtValidationExceptionMessage(errors);
            throw new JwtValidationException(validationErrorString, errors);
        }
        return jwt;
    }

    private String getJwtValidationExceptionMessage(Collection<OAuth2Error> errors) {
        for (OAuth2Error oAuth2Error : errors) {
            if (StringUtils.isEmpty((Object)oAuth2Error.getDescription())) continue;
            return String.format(DECODING_ERROR_MESSAGE_TEMPLATE, oAuth2Error.getDescription());
        }
        return "Unable to validate Jwt";
    }

    public static JwkSetUriJwtDecoderBuilder withIssuerLocation(String issuer) {
        return new JwkSetUriJwtDecoderBuilder(rest -> {
            Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForIssuerLocation(issuer, rest);
            JwtDecoderProviderConfigurationUtils.validateIssuer(configuration, issuer);
            return configuration.get("jwks_uri").toString();
        }, JwtDecoderProviderConfigurationUtils::getJWSAlgorithms);
    }

    public static JwkSetUriJwtDecoderBuilder withJwkSetUri(String jwkSetUri) {
        return new JwkSetUriJwtDecoderBuilder(jwkSetUri);
    }

    public static PublicKeyJwtDecoderBuilder withPublicKey(RSAPublicKey key) {
        return new PublicKeyJwtDecoderBuilder(key);
    }

    public static SecretKeyJwtDecoderBuilder withSecretKey(SecretKey secretKey) {
        return new SecretKeyJwtDecoderBuilder(secretKey);
    }

    public static final class JwkSetUriJwtDecoderBuilder {
        private Function<RestOperations, String> jwkSetUri;
        private Function<JWKSource<SecurityContext>, Set<JWSAlgorithm>> defaultAlgorithms = source -> Set.of(JWSAlgorithm.RS256);
        private Set<SignatureAlgorithm> signatureAlgorithms = new HashSet<SignatureAlgorithm>();
        private RestOperations restOperations = new RestTemplate();
        private Cache cache;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private JwkSetUriJwtDecoderBuilder(String jwkSetUri) {
            Assert.hasText((String)jwkSetUri, (String)"jwkSetUri cannot be empty");
            this.jwkSetUri = rest -> jwkSetUri;
            this.jwtProcessorCustomizer = processor -> {};
        }

        private JwkSetUriJwtDecoderBuilder(Function<RestOperations, String> jwkSetUri, Function<JWKSource<SecurityContext>, Set<JWSAlgorithm>> defaultAlgorithms) {
            Assert.notNull(jwkSetUri, (String)"jwkSetUri function cannot be null");
            Assert.notNull(defaultAlgorithms, (String)"defaultAlgorithms function cannot be null");
            this.jwkSetUri = jwkSetUri;
            this.defaultAlgorithms = defaultAlgorithms;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.signatureAlgorithms.add(signatureAlgorithm);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithms(Consumer<Set<SignatureAlgorithm>> signatureAlgorithmsConsumer) {
            Assert.notNull(signatureAlgorithmsConsumer, (String)"signatureAlgorithmsConsumer cannot be null");
            signatureAlgorithmsConsumer.accept(this.signatureAlgorithms);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder restOperations(RestOperations restOperations) {
            Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
            this.restOperations = restOperations;
            return this;
        }

        public JwkSetUriJwtDecoderBuilder cache(Cache cache) {
            Assert.notNull((Object)cache, (String)"cache cannot be null");
            this.cache = cache;
            return this;
        }

        public JwkSetUriJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        JWSKeySelector<SecurityContext> jwsKeySelector(JWKSource<SecurityContext> jwkSource) {
            if (this.signatureAlgorithms.isEmpty()) {
                return new JWSVerificationKeySelector(this.defaultAlgorithms.apply(jwkSource), jwkSource);
            }
            HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
            for (SignatureAlgorithm signatureAlgorithm : this.signatureAlgorithms) {
                JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
                jwsAlgorithms.add(jwsAlgorithm);
            }
            return new JWSVerificationKeySelector(jwsAlgorithms, jwkSource);
        }

        JWKSource<SecurityContext> jwkSource(ResourceRetriever jwkSetRetriever, String jwkSetUri) {
            if (this.cache == null) {
                return new RemoteJWKSet(JwkSetUriJwtDecoderBuilder.toURL(jwkSetUri), jwkSetRetriever);
            }
            SpringJWKSetCache jwkSetCache = new SpringJWKSetCache(jwkSetUri, this.cache);
            return new RemoteJWKSet(JwkSetUriJwtDecoderBuilder.toURL(jwkSetUri), jwkSetRetriever, (JWKSetCache)jwkSetCache);
        }

        JWTProcessor<SecurityContext> processor() {
            RestOperationsResourceRetriever jwkSetRetriever = new RestOperationsResourceRetriever(this.restOperations);
            String jwkSetUri = this.jwkSetUri.apply(this.restOperations);
            JWKSource<SecurityContext> jwkSource = this.jwkSource(jwkSetRetriever, jwkSetUri);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(this.jwsKeySelector(jwkSource));
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }

        private static URL toURL(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid JWK Set URL \"" + url + "\" : " + ex.getMessage(), ex);
            }
        }

        private static final class SpringJWKSetCache
        implements JWKSetCache {
            private final String jwkSetUri;
            private final Cache cache;
            private JWKSet jwkSet;

            SpringJWKSetCache(String jwkSetUri, Cache cache) {
                this.jwkSetUri = jwkSetUri;
                this.cache = cache;
                this.updateJwkSetFromCache();
            }

            private void updateJwkSetFromCache() {
                String cachedJwkSet = (String)this.cache.get((Object)this.jwkSetUri, String.class);
                if (cachedJwkSet != null) {
                    try {
                        this.jwkSet = JWKSet.parse((String)cachedJwkSet);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }

            public void put(JWKSet jwkSet) {
                this.jwkSet = jwkSet;
                this.cache.put((Object)this.jwkSetUri, (Object)jwkSet.toString(false));
            }

            public JWKSet get() {
                return !this.requiresRefresh() ? this.jwkSet : null;
            }

            public boolean requiresRefresh() {
                return this.cache.get((Object)this.jwkSetUri) == null;
            }
        }

        private static class RestOperationsResourceRetriever
        implements ResourceRetriever {
            private static final MediaType APPLICATION_JWK_SET_JSON = new MediaType("application", "jwk-set+json");
            private final RestOperations restOperations;

            RestOperationsResourceRetriever(RestOperations restOperations) {
                Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
                this.restOperations = restOperations;
            }

            public Resource retrieveResource(URL url) throws IOException {
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_JWK_SET_JSON));
                ResponseEntity<String> response = this.getResponse(url, headers);
                if (response.getStatusCodeValue() != 200) {
                    throw new IOException(response.toString());
                }
                return new Resource((String)response.getBody(), "UTF-8");
            }

            private ResponseEntity<String> getResponse(URL url, HttpHeaders headers) throws IOException {
                try {
                    RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, url.toURI());
                    return this.restOperations.exchange(request, String.class);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    public static final class PublicKeyJwtDecoderBuilder {
        private JWSAlgorithm jwsAlgorithm;
        private RSAPublicKey key;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private PublicKeyJwtDecoderBuilder(RSAPublicKey key) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.RS256;
            this.key = key;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public PublicKeyJwtDecoderBuilder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
            return this;
        }

        public PublicKeyJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        JWTProcessor<SecurityContext> processor() {
            Assert.state((boolean)JWSAlgorithm.Family.RSA.contains((Object)this.jwsAlgorithm), () -> "The provided key is of type RSA; however the signature algorithm is of some other type: " + this.jwsAlgorithm + ". Please indicate one of RS256, RS384, or RS512.");
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, (Key)this.key);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }
    }

    public static final class SecretKeyJwtDecoderBuilder {
        private final SecretKey secretKey;
        private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.HS256;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private SecretKeyJwtDecoderBuilder(SecretKey secretKey) {
            Assert.notNull((Object)secretKey, (String)"secretKey cannot be null");
            this.secretKey = secretKey;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public SecretKeyJwtDecoderBuilder macAlgorithm(MacAlgorithm macAlgorithm) {
            Assert.notNull((Object)macAlgorithm, (String)"macAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)macAlgorithm.getName());
            return this;
        }

        public SecretKeyJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        public NimbusJwtDecoder build() {
            return new NimbusJwtDecoder(this.processor());
        }

        JWTProcessor<SecurityContext> processor() {
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, (Key)this.secretKey);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }
    }
}

