/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.util.Assert;

public abstract class AbstractOAuth2TokenAuthenticationToken<T extends AbstractOAuth2Token>
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 510L;
    private T token;

    protected AbstractOAuth2TokenAuthenticationToken(T token) {
        this(token, null);
    }

    protected AbstractOAuth2TokenAuthenticationToken(T token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.notNull(token, (String)"token cannot be null");
        this.token = token;
    }

    public Object getPrincipal() {
        return this.getToken();
    }

    public Object getCredentials() {
        return this.getToken();
    }

    public final T getToken() {
        return this.token;
    }

    public abstract Map<String, Object> getTokenAttributes();
}

