/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.Assert;

public final class JwtAuthenticationProvider
implements AuthenticationProvider {
    private final JwtDecoder jwtDecoder;
    private Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter = new JwtAuthenticationConverter();
    private static final OAuth2Error DEFAULT_INVALID_TOKEN = JwtAuthenticationProvider.invalidToken("An error occurred while attempting to decode the Jwt: Invalid token");

    public JwtAuthenticationProvider(JwtDecoder jwtDecoder) {
        Assert.notNull((Object)jwtDecoder, (String)"jwtDecoder cannot be null");
        this.jwtDecoder = jwtDecoder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Jwt jwt;
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        try {
            jwt = this.jwtDecoder.decode(bearer.getToken());
        }
        catch (JwtException failed) {
            OAuth2Error invalidToken = JwtAuthenticationProvider.invalidToken(failed.getMessage());
            throw new OAuth2AuthenticationException(invalidToken, invalidToken.getDescription(), (Throwable)failed);
        }
        AbstractAuthenticationToken token = (AbstractAuthenticationToken)this.jwtAuthenticationConverter.convert((Object)jwt);
        token.setDetails(bearer.getDetails());
        return token;
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setJwtAuthenticationConverter(Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter) {
        Assert.notNull(jwtAuthenticationConverter, (String)"jwtAuthenticationConverter cannot be null");
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    }

    private static OAuth2Error invalidToken(String message) {
        try {
            return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, "https://tools.ietf.org/html/rfc6750#section-3.1");
        }
        catch (IllegalArgumentException malformed) {
            return DEFAULT_INVALID_TOKEN;
        }
    }
}

