/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.FactorGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.util.Assert;

public class JwtAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private static final String AUTHORITY = "FACTOR_BEARER";
    private Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    private String principalClaimName = "sub";

    public final AbstractAuthenticationToken convert(Jwt jwt) {
        HashSet<FactorGrantedAuthority> authorities = new HashSet<FactorGrantedAuthority>((Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt));
        authorities.add(FactorGrantedAuthority.fromAuthority((String)AUTHORITY));
        String principalClaimValue = jwt.getClaimAsString(this.principalClaimName);
        return new JwtAuthenticationToken(jwt, authorities, principalClaimValue);
    }

    public void setJwtGrantedAuthoritiesConverter(Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        Assert.notNull(jwtGrantedAuthoritiesConverter, (String)"jwtGrantedAuthoritiesConverter cannot be null");
        this.jwtGrantedAuthoritiesConverter = jwtGrantedAuthoritiesConverter;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        Assert.hasText((String)principalClaimName, (String)"principalClaimName cannot be empty");
        this.principalClaimName = principalClaimName;
    }
}

