/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;

public class PortletSessionContextIntegrationInterceptor
implements InitializingBean,
HandlerInterceptor {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor == null ? (class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor = PortletSessionContextIntegrationInterceptor.class$("org.springframework.security.context.PortletSessionContextIntegrationInterceptor")) : class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor));
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    private static final String SESSION_EXISTED = (class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor == null ? (class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor = PortletSessionContextIntegrationInterceptor.class$("org.springframework.security.context.PortletSessionContextIntegrationInterceptor")) : class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor).getName() + ".SESSION_EXISTED";
    private static final String CONTEXT_HASHCODE = (class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor == null ? (class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor = PortletSessionContextIntegrationInterceptor.class$("org.springframework.security.context.PortletSessionContextIntegrationInterceptor")) : class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor).getName() + ".CONTEXT_HASHCODE";
    private Class context = class$org$springframework$security$context$SecurityContextImpl == null ? (class$org$springframework$security$context$SecurityContextImpl = PortletSessionContextIntegrationInterceptor.class$("org.springframework.security.context.SecurityContextImpl")) : class$org$springframework$security$context$SecurityContextImpl;
    private Object contextObject = this.generateNewContext();
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    private boolean cloneFromPortletSession = false;
    private boolean useApplicationScopePortletSession = true;
    static /* synthetic */ Class class$org$springframework$security$context$PortletSessionContextIntegrationInterceptor;
    static /* synthetic */ Class class$org$springframework$security$context$SecurityContextImpl;
    static /* synthetic */ Class class$org$springframework$security$context$SecurityContext;
    static /* synthetic */ Class class$java$lang$Cloneable;

    public void afterPropertiesSet() throws Exception {
        if (this.context == null || !(class$org$springframework$security$context$SecurityContext == null ? (class$org$springframework$security$context$SecurityContext = PortletSessionContextIntegrationInterceptor.class$("org.springframework.security.context.SecurityContext")) : class$org$springframework$security$context$SecurityContext).isAssignableFrom(this.context)) {
            throw new IllegalArgumentException("context must be defined and implement SecurityContext (typically use org.springframework.security.context.SecurityContextImpl; existing class is " + this.context + ")");
        }
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
    }

    public boolean preHandleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public boolean preHandleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterActionCompletion(ActionRequest request, ActionResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    public void afterRenderCompletion(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    private boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        PortletSession portletSession = null;
        boolean portletSessionExistedAtStartOfRequest = false;
        try {
            portletSession = request.getPortletSession(this.forceEagerSessionCreation);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        if (portletSession != null) {
            portletSessionExistedAtStartOfRequest = true;
            Object contextFromSessionObject = portletSession.getAttribute(SPRING_SECURITY_CONTEXT_KEY, this.portletSessionScope());
            if (contextFromSessionObject != null) {
                if (this.cloneFromPortletSession) {
                    Assert.isInstanceOf((Class)(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = PortletSessionContextIntegrationInterceptor.class$("java.lang.Cloneable")) : class$java$lang$Cloneable), (Object)contextFromSessionObject, (String)"Context must implement Clonable and provide a Object.clone() method");
                    try {
                        Method m = contextFromSessionObject.getClass().getMethod("clone", new Class[0]);
                        if (!m.isAccessible()) {
                            ((AccessibleObject)m).setAccessible(true);
                        }
                        contextFromSessionObject = m.invoke(contextFromSessionObject, new Object[0]);
                    }
                    catch (Exception ex) {
                        ReflectionUtils.handleReflectionException((Exception)ex);
                    }
                }
                if (contextFromSessionObject instanceof SecurityContext) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Obtained from SPRING_SECURITY_CONTEXT a valid SecurityContext and set to SecurityContextHolder: '" + contextFromSessionObject + "'"));
                    }
                    SecurityContextHolder.setContext((SecurityContext)((SecurityContext)contextFromSessionObject));
                } else {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("SPRING_SECURITY_CONTEXT did not contain a SecurityContext but contained: '" + contextFromSessionObject + "'; are you improperly modifying the PortletSession directly " + "(you should always use SecurityContextHolder) or using the PortletSession attribute " + "reserved for this class? - new SecurityContext instance associated with " + "SecurityContextHolder"));
                    }
                    SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"PortletSession returned null object for SPRING_SECURITY_CONTEXT - new SecurityContext instance associated with SecurityContextHolder");
                }
                SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No PortletSession currently exists - new SecurityContext instance associated with SecurityContextHolder");
            }
            SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
        }
        request.setAttribute(SESSION_EXISTED, (Object)new Boolean(portletSessionExistedAtStartOfRequest));
        request.setAttribute(CONTEXT_HASHCODE, (Object)new Integer(SecurityContextHolder.getContext().hashCode()));
        return true;
    }

    private void afterCompletion(PortletRequest request, PortletResponse response, Object handler, Exception ex) throws Exception {
        PortletSession portletSession = null;
        boolean portletSessionExistedAtStartOfRequest = (Boolean)request.getAttribute(SESSION_EXISTED);
        int oldContextHashCode = (Integer)request.getAttribute(CONTEXT_HASHCODE);
        try {
            portletSession = request.getPortletSession(false);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        if (portletSession == null && portletSessionExistedAtStartOfRequest && logger.isDebugEnabled()) {
            logger.debug((Object)"PortletSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
        }
        if (portletSession == null && !portletSessionExistedAtStartOfRequest) {
            if (!this.allowSessionCreation) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The PortletSession is currently null, and the PortletSessionContextIntegrationInterceptor is prohibited from creating a PortletSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                }
            } else if (!this.contextObject.equals(SecurityContextHolder.getContext())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"PortletSession being created as SecurityContextHolder contents are non-default");
                }
                try {
                    portletSession = request.getPortletSession(true);
                }
                catch (IllegalStateException ignored) {}
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("PortletSession is null, but SecurityContextHolder has not changed from default: ' " + SecurityContextHolder.getContext() + "'; not creating PortletSession or storing SecurityContextHolder contents"));
            }
        }
        if (portletSession != null && SecurityContextHolder.getContext().hashCode() != oldContextHashCode) {
            portletSession.setAttribute(SPRING_SECURITY_CONTEXT_KEY, (Object)SecurityContextHolder.getContext(), this.portletSessionScope());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContext stored to PortletSession: '" + SecurityContextHolder.getContext() + "'"));
            }
        }
        SecurityContextHolder.clearContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SecurityContextHolder set to new context, as request processing completed");
        }
    }

    public SecurityContext generateNewContext() throws PortletException {
        try {
            return (SecurityContext)this.context.newInstance();
        }
        catch (InstantiationException ie) {
            throw new PortletException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new PortletException((Throwable)iae);
        }
    }

    private int portletSessionScope() {
        return this.useApplicationScopePortletSession ? 1 : 2;
    }

    public Class getContext() {
        return this.context;
    }

    public void setContext(Class secureContext) {
        this.context = secureContext;
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    public boolean isCloneFromPortletSession() {
        return this.cloneFromPortletSession;
    }

    public void setCloneFromPortletSession(boolean cloneFromPortletSession) {
        this.cloneFromPortletSession = cloneFromPortletSession;
    }

    public boolean isUseApplicationScopePortletSession() {
        return this.useApplicationScopePortletSession;
    }

    public void setUseApplicationScopePortletSession(boolean useApplicationScopePortletSession) {
        this.useApplicationScopePortletSession = useApplicationScopePortletSession;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

