/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.portlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.AuthenticationDetailsSourceImpl;
import org.springframework.util.Assert;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;

public class PortletProcessingInterceptor
implements HandlerInterceptor,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ui$portlet$PortletProcessingInterceptor == null ? (class$org$springframework$security$ui$portlet$PortletProcessingInterceptor = PortletProcessingInterceptor.class$("org.springframework.security.ui.portlet.PortletProcessingInterceptor")) : class$org$springframework$security$ui$portlet$PortletProcessingInterceptor));
    private AuthenticationManager authenticationManager;
    private List userNameAttributes;
    private AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private boolean useAuthTypeAsCredentials = false;
    static /* synthetic */ Class class$org$springframework$security$ui$portlet$PortletProcessingInterceptor;
    static /* synthetic */ Class class$org$springframework$security$ui$portlet$PortletAuthenticationDetails;

    public PortletProcessingInterceptor() {
        ((AuthenticationDetailsSourceImpl)this.authenticationDetailsSource).setClazz(class$org$springframework$security$ui$portlet$PortletAuthenticationDetails == null ? (class$org$springframework$security$ui$portlet$PortletAuthenticationDetails = PortletProcessingInterceptor.class$("org.springframework.security.ui.portlet.PortletAuthenticationDetails")) : class$org$springframework$security$ui$portlet$PortletAuthenticationDetails);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager must be set");
    }

    public boolean preHandleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public boolean preHandleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterActionCompletion(ActionRequest request, ActionResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterRenderCompletion(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
    }

    private boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking secure context token: " + ctx.getAuthentication()));
        }
        if (ctx.getAuthentication() == null) {
            try {
                PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(this.getPrincipalFromRequest(request), this.getCredentialsFromRequest(request));
                authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Beginning authentication request for user '" + authRequest.getName() + "'"));
                }
                this.onPreAuthentication(request, response);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication success: " + authResult));
                }
                ctx.setAuthentication(authResult);
                this.onSuccessfulAuthentication(request, response, authResult);
            }
            catch (AuthenticationException failed) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authentication failed - updating ContextHolder to contain null Authentication", (Throwable)failed);
                }
                ctx.setAuthentication(null);
                request.getPortletSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)failed, 1);
                this.onUnsuccessfulAuthentication(request, response, failed);
            }
        }
        return true;
    }

    protected Object getPrincipalFromRequest(PortletRequest request) {
        String userPrincipalName;
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            return remoteUser;
        }
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && (userPrincipalName = userPrincipal.getName()) != null) {
            return userPrincipalName;
        }
        if (this.userNameAttributes != null) {
            Map userInfo = null;
            try {
                userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
            }
            catch (Exception e) {
                logger.warn((Object)"unable to retrieve USER_INFO map from portlet request", (Throwable)e);
            }
            if (userInfo != null) {
                Iterator i = this.userNameAttributes.iterator();
                while (i.hasNext()) {
                    String principal = (String)userInfo.get(i.next());
                    if (principal == null) continue;
                    return principal;
                }
            }
        }
        return null;
    }

    protected Object getCredentialsFromRequest(PortletRequest request) {
        if (this.useAuthTypeAsCredentials) {
            return request.getAuthType();
        }
        return "dummy";
    }

    protected void onPreAuthentication(PortletRequest request, PortletResponse response) throws AuthenticationException, IOException {
    }

    protected void onSuccessfulAuthentication(PortletRequest request, PortletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(PortletRequest request, PortletResponse response, AuthenticationException failed) throws IOException {
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setUserNameAttributes(List userNameAttributes) {
        this.userNameAttributes = userNameAttributes;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setUseAuthTypeAsCredentials(boolean useAuthTypeAsCredentials) {
        this.useAuthTypeAsCredentials = useAuthTypeAsCredentials;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

