/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.portlet;

import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSessionContextIntegrationInterceptor
implements InitializingBean,
HandlerInterceptor {
    protected static final Log logger = LogFactory.getLog(PortletSessionContextIntegrationInterceptor.class);
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    private static final String SESSION_EXISTED = PortletSessionContextIntegrationInterceptor.class.getName() + ".SESSION_EXISTED";
    private static final String CONTEXT_HASHCODE = PortletSessionContextIntegrationInterceptor.class.getName() + ".CONTEXT_HASHCODE";
    private Class<? extends SecurityContext> contextClass;
    private Object contextObject = this.generateNewContext();
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    private boolean cloneFromPortletSession = false;
    private boolean useApplicationScopePortletSession = true;

    public void afterPropertiesSet() throws Exception {
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
    }

    public boolean preHandleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public boolean preHandleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterActionCompletion(ActionRequest request, ActionResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    public void afterRenderCompletion(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    public boolean preHandleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void postHandleResource(ResourceRequest request, ResourceResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterResourceCompletion(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    public boolean preHandleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
        return this.preHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void afterEventCompletion(EventRequest request, EventResponse response, Object handler, Exception ex) throws Exception {
        this.afterCompletion((PortletRequest)request, (PortletResponse)response, handler, ex);
    }

    private boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        PortletSession portletSession = null;
        boolean portletSessionExistedAtStartOfRequest = false;
        try {
            portletSession = request.getPortletSession(this.forceEagerSessionCreation);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        if (portletSession != null) {
            portletSessionExistedAtStartOfRequest = true;
            Object contextFromSessionObject = portletSession.getAttribute(SPRING_SECURITY_CONTEXT_KEY, this.portletSessionScope());
            if (contextFromSessionObject != null) {
                if (this.cloneFromPortletSession) {
                    Assert.isInstanceOf(Cloneable.class, (Object)contextFromSessionObject, (String)"Context must implement Clonable and provide a Object.clone() method");
                    try {
                        Method m = contextFromSessionObject.getClass().getMethod("clone", new Class[0]);
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                        }
                        contextFromSessionObject = m.invoke(contextFromSessionObject, new Object[0]);
                    }
                    catch (Exception ex) {
                        ReflectionUtils.handleReflectionException((Exception)ex);
                    }
                }
                if (contextFromSessionObject instanceof SecurityContext) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Obtained from SPRING_SECURITY_CONTEXT a valid SecurityContext and set to SecurityContextHolder: '" + contextFromSessionObject + "'"));
                    }
                    SecurityContextHolder.setContext((SecurityContext)((SecurityContext)contextFromSessionObject));
                } else {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("SPRING_SECURITY_CONTEXT did not contain a SecurityContext but contained: '" + contextFromSessionObject + "'; are you improperly modifying the PortletSession directly " + "(you should always use SecurityContextHolder) or using the PortletSession attribute " + "reserved for this class? - new SecurityContext instance associated with " + "SecurityContextHolder"));
                    }
                    SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"PortletSession returned null object for SPRING_SECURITY_CONTEXT - new SecurityContext instance associated with SecurityContextHolder");
                }
                SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No PortletSession currently exists - new SecurityContext instance associated with SecurityContextHolder");
            }
            SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
        }
        request.setAttribute(SESSION_EXISTED, (Object)new Boolean(portletSessionExistedAtStartOfRequest));
        request.setAttribute(CONTEXT_HASHCODE, (Object)new Integer(SecurityContextHolder.getContext().hashCode()));
        return true;
    }

    private void afterCompletion(PortletRequest request, PortletResponse response, Object handler, Exception ex) throws Exception {
        PortletSession portletSession = null;
        boolean portletSessionExistedAtStartOfRequest = (Boolean)request.getAttribute(SESSION_EXISTED);
        int oldContextHashCode = (Integer)request.getAttribute(CONTEXT_HASHCODE);
        try {
            portletSession = request.getPortletSession(false);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        if (portletSession == null && portletSessionExistedAtStartOfRequest && logger.isDebugEnabled()) {
            logger.debug((Object)"PortletSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
        }
        if (portletSession == null && !portletSessionExistedAtStartOfRequest) {
            if (!this.allowSessionCreation) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The PortletSession is currently null, and the PortletSessionContextIntegrationInterceptor is prohibited from creating a PortletSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                }
            } else if (!this.contextObject.equals(SecurityContextHolder.getContext())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"PortletSession being created as SecurityContextHolder contents are non-default");
                }
                try {
                    portletSession = request.getPortletSession(true);
                }
                catch (IllegalStateException ignored) {}
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("PortletSession is null, but SecurityContextHolder has not changed from default: ' " + SecurityContextHolder.getContext() + "'; not creating PortletSession or storing SecurityContextHolder contents"));
            }
        }
        if (portletSession != null && SecurityContextHolder.getContext().hashCode() != oldContextHashCode) {
            portletSession.setAttribute(SPRING_SECURITY_CONTEXT_KEY, (Object)SecurityContextHolder.getContext(), this.portletSessionScope());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContext stored to PortletSession: '" + SecurityContextHolder.getContext() + "'"));
            }
        }
        SecurityContextHolder.clearContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SecurityContextHolder set to new contextClass, as request processing completed");
        }
    }

    SecurityContext generateNewContext() throws PortletException {
        if (this.contextClass == null) {
            return SecurityContextHolder.createEmptyContext();
        }
        try {
            return this.contextClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new PortletException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new PortletException((Throwable)iae);
        }
    }

    private int portletSessionScope() {
        return this.useApplicationScopePortletSession ? 1 : 2;
    }

    public Class<? extends SecurityContext> getContext() {
        return this.contextClass;
    }

    public void setContext(Class<? extends SecurityContext> secureContext) {
        this.contextClass = secureContext;
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    public boolean isCloneFromPortletSession() {
        return this.cloneFromPortletSession;
    }

    public void setCloneFromPortletSession(boolean cloneFromPortletSession) {
        this.cloneFromPortletSession = cloneFromPortletSession;
    }

    public boolean isUseApplicationScopePortletSession() {
        return this.useApplicationScopePortletSession;
    }

    public void setUseApplicationScopePortletSession(boolean useApplicationScopePortletSession) {
        this.useApplicationScopePortletSession = useApplicationScopePortletSession;
    }
}

