/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.metadata;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.EntitiesDescriptorMarshaller;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class OpenSamlMetadataResolver
implements Saml2MetadataResolver {
    private final EntityDescriptorMarshaller entityDescriptorMarshaller;
    private final EntitiesDescriptorMarshaller entitiesDescriptorMarshaller;
    private Consumer<EntityDescriptorParameters> entityDescriptorCustomizer = parameters -> {};
    private boolean usePrettyPrint = true;

    public OpenSamlMetadataResolver() {
        this.entityDescriptorMarshaller = (EntityDescriptorMarshaller)XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.entityDescriptorMarshaller, (String)"entityDescriptorMarshaller cannot be null");
        this.entitiesDescriptorMarshaller = (EntitiesDescriptorMarshaller)XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.entitiesDescriptorMarshaller, (String)"entitiesDescriptorMarshaller cannot be null");
    }

    @Override
    public String resolve(RelyingPartyRegistration relyingPartyRegistration) {
        EntityDescriptor entityDescriptor = this.entityDescriptor(relyingPartyRegistration);
        return this.serialize(entityDescriptor);
    }

    @Override
    public String resolve(Iterable<RelyingPartyRegistration> relyingPartyRegistrations) {
        ArrayList<EntityDescriptor> entityDescriptors = new ArrayList<EntityDescriptor>();
        for (RelyingPartyRegistration registration : relyingPartyRegistrations) {
            EntityDescriptor entityDescriptor = this.entityDescriptor(registration);
            entityDescriptors.add(entityDescriptor);
        }
        if (entityDescriptors.size() == 1) {
            return this.serialize((EntityDescriptor)entityDescriptors.iterator().next());
        }
        EntitiesDescriptor entities = (EntitiesDescriptor)this.build(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        entities.getEntityDescriptors().addAll(entityDescriptors);
        return this.serialize(entities);
    }

    private EntityDescriptor entityDescriptor(RelyingPartyRegistration registration) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.build(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDescriptor.setEntityID(registration.getEntityId());
        SPSSODescriptor spSsoDescriptor = this.buildSpSsoDescriptor(registration);
        entityDescriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).add(spSsoDescriptor);
        this.entityDescriptorCustomizer.accept(new EntityDescriptorParameters(entityDescriptor, registration));
        return entityDescriptor;
    }

    public void setEntityDescriptorCustomizer(Consumer<EntityDescriptorParameters> entityDescriptorCustomizer) {
        Assert.notNull(entityDescriptorCustomizer, (String)"entityDescriptorCustomizer cannot be null");
        this.entityDescriptorCustomizer = entityDescriptorCustomizer;
    }

    public void setUsePrettyPrint(boolean usePrettyPrint) {
        this.usePrettyPrint = usePrettyPrint;
    }

    private SPSSODescriptor buildSpSsoDescriptor(RelyingPartyRegistration registration) {
        SPSSODescriptor spSsoDescriptor = (SPSSODescriptor)this.build(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSsoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spSsoDescriptor.getKeyDescriptors().addAll(this.buildKeys(registration.getSigningX509Credentials(), UsageType.SIGNING));
        spSsoDescriptor.getKeyDescriptors().addAll(this.buildKeys(registration.getDecryptionX509Credentials(), UsageType.ENCRYPTION));
        spSsoDescriptor.getAssertionConsumerServices().add(this.buildAssertionConsumerService(registration));
        if (registration.getSingleLogoutServiceLocation() != null) {
            for (Saml2MessageBinding binding : registration.getSingleLogoutServiceBindings()) {
                spSsoDescriptor.getSingleLogoutServices().add(this.buildSingleLogoutService(registration, binding));
            }
        }
        if (registration.getNameIdFormat() != null) {
            spSsoDescriptor.getNameIDFormats().add(this.buildNameIDFormat(registration));
        }
        return spSsoDescriptor;
    }

    private List<KeyDescriptor> buildKeys(Collection<Saml2X509Credential> credentials, UsageType usageType) {
        ArrayList<KeyDescriptor> list = new ArrayList<KeyDescriptor>();
        for (Saml2X509Credential credential : credentials) {
            KeyDescriptor keyDescriptor = this.buildKeyDescriptor(usageType, credential.getCertificate());
            list.add(keyDescriptor);
        }
        return list;
    }

    private KeyDescriptor buildKeyDescriptor(UsageType usageType, java.security.cert.X509Certificate certificate) {
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.build(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo = (KeyInfo)this.build(KeyInfo.DEFAULT_ELEMENT_NAME);
        X509Certificate x509Certificate = (X509Certificate)this.build(X509Certificate.DEFAULT_ELEMENT_NAME);
        X509Data x509Data = (X509Data)this.build(X509Data.DEFAULT_ELEMENT_NAME);
        try {
            x509Certificate.setValue(new String(Base64.getEncoder().encode(certificate.getEncoded())));
        }
        catch (CertificateEncodingException ex) {
            throw new Saml2Exception("Cannot encode certificate " + certificate.toString());
        }
        x509Data.getX509Certificates().add(x509Certificate);
        keyInfo.getX509Datas().add(x509Data);
        keyDescriptor.setUse(usageType);
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    private AssertionConsumerService buildAssertionConsumerService(RelyingPartyRegistration registration) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)this.build(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        assertionConsumerService.setLocation(registration.getAssertionConsumerServiceLocation());
        assertionConsumerService.setBinding(registration.getAssertionConsumerServiceBinding().getUrn());
        assertionConsumerService.setIndex(Integer.valueOf(1));
        return assertionConsumerService;
    }

    private SingleLogoutService buildSingleLogoutService(RelyingPartyRegistration registration, Saml2MessageBinding binding) {
        SingleLogoutService singleLogoutService = (SingleLogoutService)this.build(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        singleLogoutService.setLocation(registration.getSingleLogoutServiceLocation());
        singleLogoutService.setResponseLocation(registration.getSingleLogoutServiceResponseLocation());
        singleLogoutService.setBinding(binding.getUrn());
        return singleLogoutService;
    }

    private NameIDFormat buildNameIDFormat(RelyingPartyRegistration registration) {
        NameIDFormat nameIdFormat = (NameIDFormat)this.build(NameIDFormat.DEFAULT_ELEMENT_NAME);
        nameIdFormat.setURI(registration.getNameIdFormat());
        return nameIdFormat;
    }

    private <T> T build(QName elementName) {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(elementName);
        if (builder == null) {
            throw new Saml2Exception("Unable to resolve Builder for " + elementName);
        }
        return (T)builder.buildObject(elementName);
    }

    private String serialize(EntityDescriptor entityDescriptor) {
        try {
            Element element = this.entityDescriptorMarshaller.marshall((XMLObject)entityDescriptor);
            if (this.usePrettyPrint) {
                return SerializeSupport.prettyPrintXML((Node)element);
            }
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private String serialize(EntitiesDescriptor entities) {
        try {
            Element element = this.entitiesDescriptorMarshaller.marshall((XMLObject)entities);
            if (this.usePrettyPrint) {
                return SerializeSupport.prettyPrintXML((Node)element);
            }
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    public static final class EntityDescriptorParameters {
        private final EntityDescriptor entityDescriptor;
        private final RelyingPartyRegistration registration;

        public EntityDescriptorParameters(EntityDescriptor entityDescriptor, RelyingPartyRegistration registration) {
            this.entityDescriptor = entityDescriptor;
            this.registration = registration;
        }

        public EntityDescriptor getEntityDescriptor() {
            return this.entityDescriptor;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }
    }
}

