/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.session;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSessionControlStrategy
extends SessionFixationProtectionStrategy
implements MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private final SessionRegistry sessionRegistry;
    private boolean exceptionIfMaximumExceeded = false;
    private int maximumSessions = 1;

    public ConcurrentSessionControlStrategy(SessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"The sessionRegistry cannot be null");
        super.setAlwaysCreateSession(true);
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        this.checkAuthenticationAllowed(authentication, request);
        super.onAuthentication(authentication, request, response);
        this.sessionRegistry.registerNewSession(request.getSession().getId(), authentication.getPrincipal());
    }

    private void checkAuthenticationAllowed(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        HttpSession session;
        int allowedSessions;
        List sessions = this.sessionRegistry.getAllSessions(authentication.getPrincipal(), false);
        int sessionCount = sessions == null ? 0 : sessions.size();
        if (sessionCount < (allowedSessions = this.getMaximumSessionsForThisUser(authentication))) {
            return;
        }
        if (allowedSessions == -1) {
            return;
        }
        if (sessionCount == allowedSessions && (session = request.getSession(false)) != null) {
            for (SessionInformation si : sessions) {
                if (!si.getSessionId().equals(session.getId())) continue;
                return;
            }
        }
        this.allowableSessionsExceeded(sessions, allowedSessions, this.sessionRegistry);
    }

    protected int getMaximumSessionsForThisUser(Authentication authentication) {
        return this.maximumSessions;
    }

    protected void allowableSessionsExceeded(List<SessionInformation> sessions, int allowableSessions, SessionRegistry registry) throws SessionAuthenticationException {
        if (this.exceptionIfMaximumExceeded || sessions == null) {
            throw new SessionAuthenticationException(this.messages.getMessage("ConcurrentSessionControllerImpl.exceededAllowed", new Object[]{new Integer(allowableSessions)}, "Maximum sessions of {0} for this principal exceeded"));
        }
        SessionInformation leastRecentlyUsed = null;
        for (int i = 0; i < sessions.size(); ++i) {
            if (leastRecentlyUsed != null && !sessions.get(i).getLastRequest().before(leastRecentlyUsed.getLastRequest())) continue;
            leastRecentlyUsed = sessions.get(i);
        }
        leastRecentlyUsed.expireNow();
    }

    @Override
    protected void onSessionChange(String originalSessionId, HttpSession newSession, Authentication auth) {
        this.sessionRegistry.removeSessionInformation(originalSessionId);
        this.sessionRegistry.registerNewSession(newSession.getId(), auth.getPrincipal());
    }

    public void setExceptionIfMaximumExceeded(boolean exceptionIfMaximumExceeded) {
        this.exceptionIfMaximumExceeded = exceptionIfMaximumExceeded;
    }

    public void setMaximumSessions(int maximumSessions) {
        Assert.isTrue((maximumSessions != 0 ? 1 : 0) != 0, (String)"MaximumLogins must be either -1 to allow unlimited logins, or a positive integer to specify a maximum");
        this.maximumSessions = maximumSessions;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    @Override
    public final void setAlwaysCreateSession(boolean alwaysCreateSession) {
        if (!alwaysCreateSession) {
            throw new IllegalArgumentException("Cannot set alwaysCreateSession to false when concurrent session control is required");
        }
    }
}

