/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

public class JdbcTokenRepositoryImpl
extends JdbcDaoSupport
implements PersistentTokenRepository {
    public static final String CREATE_TABLE_SQL = "create table persistent_logins (username varchar(64) not null, series varchar(64) primary key, token varchar(64) not null, last_used timestamp not null)";
    public static final String DEF_TOKEN_BY_SERIES_SQL = "select username,series,token,last_used from persistent_logins where series = ?";
    public static final String DEF_INSERT_TOKEN_SQL = "insert into persistent_logins (username, series, token, last_used) values(?,?,?,?)";
    public static final String DEF_UPDATE_TOKEN_SQL = "update persistent_logins set token = ?, last_used = ? where series = ?";
    public static final String DEF_REMOVE_USER_TOKENS_SQL = "delete from persistent_logins where username = ?";
    private String tokensBySeriesSql = "select username,series,token,last_used from persistent_logins where series = ?";
    private String insertTokenSql = "insert into persistent_logins (username, series, token, last_used) values(?,?,?,?)";
    private String updateTokenSql = "update persistent_logins set token = ?, last_used = ? where series = ?";
    private String removeUserTokensSql = "delete from persistent_logins where username = ?";
    private boolean createTableOnStartup;
    private MappingSqlQuery<PersistentRememberMeToken> tokensBySeriesMapping;
    private SqlUpdate insertToken;
    private SqlUpdate updateToken;
    private SqlUpdate removeUserTokens;

    protected void initDao() {
        this.tokensBySeriesMapping = new TokensBySeriesMapping(this.getDataSource());
        this.insertToken = new InsertToken(this.getDataSource());
        this.updateToken = new UpdateToken(this.getDataSource());
        this.removeUserTokens = new RemoveUserTokens(this.getDataSource());
        if (this.createTableOnStartup) {
            this.getJdbcTemplate().execute(CREATE_TABLE_SQL);
        }
    }

    public void createNewToken(PersistentRememberMeToken token) {
        this.insertToken.update(new Object[]{token.getUsername(), token.getSeries(), token.getTokenValue(), token.getDate()});
    }

    public void updateToken(String series, String tokenValue, Date lastUsed) {
        this.updateToken.update(new Object[]{tokenValue, new Date(), series});
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        try {
            return (PersistentRememberMeToken)this.tokensBySeriesMapping.findObject(seriesId);
        }
        catch (IncorrectResultSizeDataAccessException moreThanOne) {
            this.logger.error((Object)("Querying token for series '" + seriesId + "' returned more than one value. Series" + " should be unique"));
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("Failed to load token for series " + seriesId), (Throwable)e);
        }
        return null;
    }

    public void removeUserTokens(String username) {
        this.removeUserTokens.update(username);
    }

    public void setCreateTableOnStartup(boolean createTableOnStartup) {
        this.createTableOnStartup = createTableOnStartup;
    }

    private class RemoveUserTokens
    extends SqlUpdate {
        public RemoveUserTokens(DataSource ds) {
            super(ds, JdbcTokenRepositoryImpl.this.removeUserTokensSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    private class InsertToken
    extends SqlUpdate {
        public InsertToken(DataSource ds) {
            super(ds, JdbcTokenRepositoryImpl.this.insertTokenSql);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(93));
            this.compile();
        }
    }

    private class UpdateToken
    extends SqlUpdate {
        public UpdateToken(DataSource ds) {
            super(ds, JdbcTokenRepositoryImpl.this.updateTokenSql);
            this.setMaxRowsAffected(1);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(93));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TokensBySeriesMapping
    extends MappingSqlQuery<PersistentRememberMeToken> {
        protected TokensBySeriesMapping(DataSource ds) {
            super(ds, JdbcTokenRepositoryImpl.this.tokensBySeriesSql);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected PersistentRememberMeToken mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new PersistentRememberMeToken(rs.getString(1), rs.getString(2), rs.getString(3), rs.getTimestamp(4));
        }
    }
}

