/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.net.URI;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectServerAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    private URI location = URI.create("/");
    private ServerRedirectStrategy serverRedirectStrategy = new DefaultServerRedirectStrategy();

    public RedirectServerAuthenticationSuccessHandler() {
    }

    public RedirectServerAuthenticationSuccessHandler(String location) {
        this.location = URI.create(location);
    }

    @Override
    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        return this.serverRedirectStrategy.sendRedirect(exchange, this.location);
    }

    public void setLocation(URI location) {
        Assert.notNull((Object)location, (String)"location cannot be null");
        this.location = location;
    }

    public void setServerRedirectStrategy(ServerRedirectStrategy serverRedirectStrategy) {
        Assert.notNull((Object)serverRedirectStrategy, (String)"redirectStrategy cannot be null");
        this.serverRedirectStrategy = serverRedirectStrategy;
    }
}

