/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.logout;

import java.util.Collection;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.SecurityContextServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogoutWebFilter
implements WebFilter {
    private AnonymousAuthenticationToken anonymousAuthenticationToken = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private ServerLogoutHandler serverLogoutHandler = new SecurityContextServerLogoutHandler();
    private ServerLogoutSuccessHandler serverLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers(HttpMethod.POST, "/logout");

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requiresLogout.matches(exchange).filter(result -> result.isMatch()).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).map(result -> exchange).flatMap(this::flatMapAuthentication).flatMap(authentication -> {
            WebFilterExchange webFilterExchange = new WebFilterExchange(exchange, chain);
            return this.logout(webFilterExchange, (Authentication)authentication);
        });
    }

    private Mono<Authentication> flatMapAuthentication(ServerWebExchange exchange) {
        return exchange.getPrincipal().cast(Authentication.class).defaultIfEmpty((Object)this.anonymousAuthenticationToken);
    }

    private Mono<Void> logout(WebFilterExchange webFilterExchange, Authentication authentication) {
        return this.serverLogoutHandler.logout(webFilterExchange, authentication).then(this.serverLogoutSuccessHandler.onLogoutSuccess(webFilterExchange, authentication)).subscriberContext(ReactiveSecurityContextHolder.clearContext());
    }

    public void setServerLogoutSuccessHandler(ServerLogoutSuccessHandler serverLogoutSuccessHandler) {
        Assert.notNull((Object)serverLogoutSuccessHandler, (String)"serverLogoutSuccessHandler cannot be null");
        this.serverLogoutSuccessHandler = serverLogoutSuccessHandler;
    }

    public void setServerLogoutHandler(ServerLogoutHandler serverLogoutHandler) {
        Assert.notNull((Object)serverLogoutHandler, (String)"logoutHandler must not be null");
        this.serverLogoutHandler = serverLogoutHandler;
    }

    public void setRequiresLogout(ServerWebExchangeMatcher serverWebExchangeMatcher) {
        Assert.notNull((Object)serverWebExchangeMatcher, (String)"serverWebExchangeMatcher must not be null");
        this.requiresLogout = serverWebExchangeMatcher;
    }
}

