/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import com.fasterxml.jackson.databind.Module;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.HttpMessageConverterAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.webauthn.api.AuthenticatorAssertionResponse;
import org.springframework.security.web.webauthn.api.PublicKeyCredential;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.authentication.HttpSessionPublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.authentication.PublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthenticationRequestToken;
import org.springframework.security.web.webauthn.jackson.WebauthnJackson2Module;
import org.springframework.security.web.webauthn.management.RelyingPartyAuthenticationRequest;
import org.springframework.util.Assert;

public class WebAuthnAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private GenericHttpMessageConverter<Object> converter = new MappingJackson2HttpMessageConverter(Jackson2ObjectMapperBuilder.json().modules(new Module[]{new WebauthnJackson2Module()}).build());
    private PublicKeyCredentialRequestOptionsRepository requestOptionsRepository = new HttpSessionPublicKeyCredentialRequestOptionsRepository();

    public WebAuthnAuthenticationFilter() {
        super(PathPatternRequestMatcher.pathPattern(HttpMethod.POST, "/login/webauthn"));
        this.setSecurityContextRepository(new HttpSessionSecurityContextRepository());
        this.setAuthenticationFailureHandler(new AuthenticationEntryPointFailureHandler(new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED)));
        this.setAuthenticationSuccessHandler(new HttpMessageConverterAuthenticationSuccessHandler());
    }

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(PublicKeyCredential.class, (Class[])new Class[]{AuthenticatorAssertionResponse.class});
        PublicKeyCredential publicKeyCredential = null;
        try {
            publicKeyCredential = (PublicKeyCredential)this.converter.read(resolvableType.getType(), ((Object)((Object)this)).getClass(), (HttpInputMessage)httpRequest);
        }
        catch (Exception ex) {
            throw new BadCredentialsException("Unable to authenticate the PublicKeyCredential", (Throwable)ex);
        }
        PublicKeyCredentialRequestOptions requestOptions = this.requestOptionsRepository.load(request);
        if (requestOptions == null) {
            throw new BadCredentialsException("Unable to authenticate the PublicKeyCredential. No PublicKeyCredentialRequestOptions found.");
        }
        this.requestOptionsRepository.save(request, response, null);
        RelyingPartyAuthenticationRequest authenticationRequest = new RelyingPartyAuthenticationRequest(requestOptions, publicKeyCredential);
        WebAuthnAuthenticationRequestToken token = new WebAuthnAuthenticationRequestToken(authenticationRequest);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }

    public void setConverter(GenericHttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    public void setRequestOptionsRepository(PublicKeyCredentialRequestOptionsRepository requestOptionsRepository) {
        Assert.notNull((Object)requestOptionsRepository, (String)"requestOptionsRepository cannot be null");
        this.requestOptionsRepository = requestOptionsRepository;
    }
}

