/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

public class RedisOperationsSessionRepository
implements SessionRepository<RedisSession> {
    static final String BOUNDED_HASH_KEY_PREFIX = "spring-security-sessions:";
    static final String CREATION_TIME_ATTR = "creationTime";
    static final String MAX_INACTIVE_ATTR = "maxInactiveInterval";
    static final String LAST_ACCESSED_ATTR = "lastAccessedTime";
    static final String SESSION_ATTR_PREFIX = "sessionAttr:";
    private final RedisOperations<String, Session> redisOperations;
    private Integer defaultMaxInactiveInterval;

    public RedisOperationsSessionRepository(RedisOperations<String, Session> redisOperations) {
        Assert.notNull(redisOperations, (String)"RedisOperations cannot be null");
        this.redisOperations = redisOperations;
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Override
    public void save(RedisSession session) {
        session.saveDelta();
    }

    @Override
    public RedisSession getSession(String id) {
        Map entries = this.getSessionBoundHashOperations(id).entries();
        if (entries.isEmpty()) {
            return null;
        }
        MapSession loaded = new MapSession();
        loaded.setId(id);
        for (Map.Entry entry : entries.entrySet()) {
            String key = (String)entry.getKey();
            if (CREATION_TIME_ATTR.equals(key)) {
                loaded.setCreationTime((Long)entry.getValue());
                continue;
            }
            if (MAX_INACTIVE_ATTR.equals(key)) {
                loaded.setMaxInactiveInterval((Integer)entry.getValue());
                continue;
            }
            if (LAST_ACCESSED_ATTR.equals(key)) {
                loaded.setLastAccessedTime((Long)entry.getValue());
                continue;
            }
            if (!key.startsWith(SESSION_ATTR_PREFIX)) continue;
            loaded.setAttribute(key.substring(SESSION_ATTR_PREFIX.length()), entry.getValue());
        }
        return new RedisSession(loaded);
    }

    @Override
    public void delete(String sessionId) {
        String key = RedisOperationsSessionRepository.getKey(sessionId);
        this.redisOperations.delete((Object)key);
    }

    @Override
    public RedisSession createSession() {
        RedisSession redisSession = new RedisSession();
        if (this.defaultMaxInactiveInterval != null) {
            redisSession.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        }
        return redisSession;
    }

    static String getKey(String sessionId) {
        return BOUNDED_HASH_KEY_PREFIX + sessionId;
    }

    static String getSessionAttrNameKey(String attributeName) {
        return SESSION_ATTR_PREFIX + attributeName;
    }

    private BoundHashOperations<String, Object, Object> getSessionBoundHashOperations(String sessionId) {
        String key = RedisOperationsSessionRepository.getKey(sessionId);
        return this.redisOperations.boundHashOps((Object)key);
    }

    final class RedisSession
    implements Session {
        private final MapSession cached;
        private Map<String, Object> delta = new HashMap<String, Object>();

        RedisSession() {
            this(new MapSession());
            this.delta.put(RedisOperationsSessionRepository.CREATION_TIME_ATTR, this.getCreationTime());
            this.delta.put(RedisOperationsSessionRepository.MAX_INACTIVE_ATTR, this.getMaxInactiveInterval());
            this.delta.put(RedisOperationsSessionRepository.LAST_ACCESSED_ATTR, this.getLastAccessedTime());
        }

        RedisSession(MapSession cached) {
            Assert.notNull((Object)"MapSession cannot be null");
            this.cached = cached;
        }

        @Override
        public void setLastAccessedTime(long lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.delta.put(RedisOperationsSessionRepository.LAST_ACCESSED_ATTR, this.getLastAccessedTime());
        }

        @Override
        public long getCreationTime() {
            return this.cached.getCreationTime();
        }

        @Override
        public String getId() {
            return this.cached.getId();
        }

        @Override
        public long getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.delta.put(RedisOperationsSessionRepository.MAX_INACTIVE_ATTR, this.getMaxInactiveInterval());
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        @Override
        public Object getAttribute(String attributeName) {
            return this.cached.getAttribute(attributeName);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.delta.put(RedisOperationsSessionRepository.getSessionAttrNameKey(attributeName), attributeValue);
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.cached.removeAttribute(attributeName);
            this.delta.put(RedisOperationsSessionRepository.getSessionAttrNameKey(attributeName), null);
        }

        private void saveDelta() {
            RedisOperationsSessionRepository.this.getSessionBoundHashOperations(this.getId()).putAll(this.delta);
            RedisOperationsSessionRepository.this.getSessionBoundHashOperations(this.getId()).expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            this.delta = new HashMap<String, Object>(this.delta.size());
        }
    }
}

