/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.session.Session;
import org.springframework.session.web.HttpSessionStrategy;
import org.springframework.util.Assert;

public final class CookieHttpSessionStrategy
implements HttpSessionStrategy {
    private String cookieName = "SESSION";

    @Override
    public String getRequestedSessionId(HttpServletRequest request) {
        Cookie session = CookieHttpSessionStrategy.getCookie(request, this.cookieName);
        return session == null ? null : session.getValue();
    }

    @Override
    public void onNewSession(Session session, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(this.cookieName, session.getId());
        cookie.setHttpOnly(true);
        cookie.setSecure(request.isSecure());
        cookie.setPath(CookieHttpSessionStrategy.cookiePath(request));
        response.addCookie(cookie);
    }

    @Override
    public void onInvalidateSession(HttpServletRequest request, HttpServletResponse response) {
        Cookie sessionCookie = new Cookie(this.cookieName, "");
        sessionCookie.setMaxAge(0);
        sessionCookie.setHttpOnly(true);
        sessionCookie.setSecure(request.isSecure());
        sessionCookie.setPath(CookieHttpSessionStrategy.cookiePath(request));
        response.addCookie(sessionCookie);
    }

    public void setCookieName(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"cookieName cannot be null");
        this.cookieName = cookieName;
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Cookie[] cookies = request.getCookies();
        Cookie result = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                if (CookieHttpSessionStrategy.cookiePath(request).equals(cookie.getPath())) {
                    return cookie;
                }
                result = cookie;
            }
        }
        return result;
    }

    private static String cookiePath(HttpServletRequest request) {
        return request.getContextPath() + "/";
    }
}

