/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class OnCommittedResponseWrapper
extends HttpServletResponseWrapper {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean disableOnCommitted;

    public OnCommittedResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void disableOnResponseCommitted() {
        this.disableOnCommitted = true;
    }

    protected abstract void onResponseCommitted();

    public final void sendError(int sc) throws IOException {
        this.doOnResponseCommitted();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.doOnResponseCommitted();
        super.sendError(sc, msg);
    }

    public final void sendRedirect(String location) throws IOException {
        this.doOnResponseCommitted();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new SaveContextServletOutputStream(super.getOutputStream());
    }

    public PrintWriter getWriter() throws IOException {
        return new SaveContextPrintWriter(super.getWriter());
    }

    public void flushBuffer() throws IOException {
        this.doOnResponseCommitted();
        super.flushBuffer();
    }

    private void doOnResponseCommitted() {
        if (!this.disableOnCommitted) {
            this.onResponseCommitted();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Skip invoking on");
        }
    }

    private class SaveContextServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;

        public SaveContextServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.flush();
        }

        public void close() throws IOException {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void print(boolean b) throws IOException {
            this.delegate.print(b);
        }

        public void print(char c) throws IOException {
            this.delegate.print(c);
        }

        public void print(double d) throws IOException {
            this.delegate.print(d);
        }

        public void print(float f) throws IOException {
            this.delegate.print(f);
        }

        public void print(int i) throws IOException {
            this.delegate.print(i);
        }

        public void print(long l) throws IOException {
            this.delegate.print(l);
        }

        public void print(String arg0) throws IOException {
            this.delegate.print(arg0);
        }

        public void println() throws IOException {
            this.delegate.println();
        }

        public void println(boolean b) throws IOException {
            this.delegate.println(b);
        }

        public void println(char c) throws IOException {
            this.delegate.println(c);
        }

        public void println(double d) throws IOException {
            this.delegate.println(d);
        }

        public void println(float f) throws IOException {
            this.delegate.println(f);
        }

        public void println(int i) throws IOException {
            this.delegate.println(i);
        }

        public void println(long l) throws IOException {
            this.delegate.println(l);
        }

        public void println(String s) throws IOException {
            this.delegate.println(s);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }
    }

    private class SaveContextPrintWriter
    extends PrintWriter {
        private final PrintWriter delegate;

        public SaveContextPrintWriter(PrintWriter delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.flush();
        }

        @Override
        public void close() {
            OnCommittedResponseWrapper.this.doOnResponseCommitted();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        @Override
        public boolean checkError() {
            return this.delegate.checkError();
        }

        @Override
        public void write(int c) {
            this.delegate.write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            this.delegate.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            this.delegate.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            this.delegate.write(s, off, len);
        }

        @Override
        public void write(String s) {
            this.delegate.write(s);
        }

        @Override
        public void print(boolean b) {
            this.delegate.print(b);
        }

        @Override
        public void print(char c) {
            this.delegate.print(c);
        }

        @Override
        public void print(int i) {
            this.delegate.print(i);
        }

        @Override
        public void print(long l) {
            this.delegate.print(l);
        }

        @Override
        public void print(float f) {
            this.delegate.print(f);
        }

        @Override
        public void print(double d) {
            this.delegate.print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegate.print(s);
        }

        @Override
        public void print(String s) {
            this.delegate.print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegate.print(obj);
        }

        @Override
        public void println() {
            this.delegate.println();
        }

        @Override
        public void println(boolean x) {
            this.delegate.println(x);
        }

        @Override
        public void println(char x) {
            this.delegate.println(x);
        }

        @Override
        public void println(int x) {
            this.delegate.println(x);
        }

        @Override
        public void println(long x) {
            this.delegate.println(x);
        }

        @Override
        public void println(float x) {
            this.delegate.println(x);
        }

        @Override
        public void println(double x) {
            this.delegate.println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegate.println(x);
        }

        @Override
        public void println(String x) {
            this.delegate.println(x);
        }

        @Override
        public void println(Object x) {
            this.delegate.println(x);
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            return this.delegate.printf(format, args);
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            return this.delegate.printf(l, format, args);
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            return this.delegate.format(format, args);
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            return this.delegate.format(l, format, args);
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            return this.delegate.append(csq);
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            return this.delegate.append(csq, start, end);
        }

        @Override
        public PrintWriter append(char c) {
            return this.delegate.append(c);
        }
    }
}

