/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.CookieHttpSessionStrategy;
import org.springframework.session.web.HttpSessionStrategy;
import org.springframework.session.web.OnCommittedResponseWrapper;
import org.springframework.session.web.OncePerRequestFilter;
import org.springframework.session.web.SessionRepositoryFilter;
import org.springframework.util.Assert;

public class SessionRepositoryFilter<S extends Session>
extends OncePerRequestFilter {
    private final SessionRepository<S> sessionRepository;
    private HttpSessionStrategy httpSessionStrategy = new CookieHttpSessionStrategy();
    private static final HttpSessionContext NOOP_SESSION_CONTEXT = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration<String> getIds() {
            return EMPTY_ENUMERATION;
        }
    };
    private static final Enumeration<String> EMPTY_ENUMERATION = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException("a");
        }
    };

    public SessionRepositoryFilter(SessionRepository<S> sessionRepository) {
        Assert.notNull(sessionRepository, (String)"SessionRepository cannot be null");
        this.sessionRepository = sessionRepository;
    }

    public void setHttpSessionStrategy(HttpSessionStrategy httpSessionStrategy) {
        Assert.notNull((Object)httpSessionStrategy, (String)"httpSessionIdStrategy cannot be null");
        this.httpSessionStrategy = httpSessionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionRepositoryRequestWrapper wrappedRequest = new SessionRepositoryRequestWrapper(request, response);
        SessionRepositoryResponseWrapper wrappedResponse = new SessionRepositoryResponseWrapper(wrappedRequest, response);
        try {
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedRequest.commitSession();
        }
    }

    private final class SessionRepositoryRequestWrapper
    extends HttpServletRequestWrapper {
        private org.springframework.session.web.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper currentSession;
        private boolean requestedValidSession;
        private final HttpServletResponse response;

        private SessionRepositoryRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.response = response;
        }

        private void commitSession() {
            org.springframework.session.web.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper wrappedSession = this.currentSession;
            if (wrappedSession == null) {
                if (this.isInvalidateClientSession()) {
                    SessionRepositoryFilter.this.httpSessionStrategy.onInvalidateSession((HttpServletRequest)this, this.response);
                }
            } else {
                Session session = ((HttpSessionWrapper)wrappedSession).session;
                SessionRepositoryFilter.this.sessionRepository.save(session);
                SessionRepositoryFilter.this.httpSessionStrategy.onNewSession(session, (HttpServletRequest)this, this.response);
            }
        }

        private boolean isInvalidateClientSession() {
            return this.currentSession == null && this.requestedValidSession;
        }

        public HttpSession getSession(boolean create) {
            Object session;
            if (this.currentSession != null) {
                return this.currentSession;
            }
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId != null && (session = SessionRepositoryFilter.this.sessionRepository.getSession(requestedSessionId)) != null) {
                this.requestedValidSession = true;
                session.setLastAccessedTime(System.currentTimeMillis());
                this.currentSession = new HttpSessionWrapper(this, session, this.getServletContext());
                this.currentSession.setNew(false);
                return this.currentSession;
            }
            if (!create) {
                return null;
            }
            session = SessionRepositoryFilter.this.sessionRepository.createSession();
            this.currentSession = new HttpSessionWrapper(this, session, this.getServletContext());
            return this.currentSession;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public String getRequestedSessionId() {
            return SessionRepositoryFilter.this.httpSessionStrategy.getRequestedSessionId((HttpServletRequest)this);
        }

        private static final class HttpSessionWrapper
        implements HttpSession {
            private final S session;
            private final ServletContext servletContext;
            private boolean invalidated;
            private boolean old;
            final /* synthetic */ SessionRepositoryRequestWrapper this$1;

            public HttpSessionWrapper(S session, ServletContext servletContext) {
                this.this$1 = var1_1;
                this.session = session;
                this.servletContext = servletContext;
            }

            void updateLastAccessedTime() {
                this.checkState();
                this.session.setLastAccessedTime(System.currentTimeMillis());
            }

            public long getCreationTime() {
                this.checkState();
                return this.session.getCreationTime();
            }

            public String getId() {
                return this.session.getId();
            }

            public long getLastAccessedTime() {
                this.checkState();
                return this.session.getLastAccessedTime();
            }

            public ServletContext getServletContext() {
                return this.servletContext;
            }

            public void setMaxInactiveInterval(int interval) {
                this.session.setMaxInactiveInterval(interval);
            }

            public int getMaxInactiveInterval() {
                return this.session.getMaxInactiveInterval();
            }

            public HttpSessionContext getSessionContext() {
                return NOOP_SESSION_CONTEXT;
            }

            public Object getAttribute(String name) {
                this.checkState();
                return this.session.getAttribute(name);
            }

            public Object getValue(String name) {
                return this.getAttribute(name);
            }

            public Enumeration<String> getAttributeNames() {
                this.checkState();
                return Collections.enumeration(this.session.getAttributeNames());
            }

            public String[] getValueNames() {
                this.checkState();
                Set<String> attrs = this.session.getAttributeNames();
                return attrs.toArray(new String[0]);
            }

            public void setAttribute(String name, Object value) {
                this.checkState();
                this.session.setAttribute(name, value);
            }

            public void putValue(String name, Object value) {
                this.setAttribute(name, value);
            }

            public void removeAttribute(String name) {
                this.checkState();
                this.session.removeAttribute(name);
            }

            public void removeValue(String name) {
                this.removeAttribute(name);
            }

            public void invalidate() {
                this.checkState();
                this.invalidated = true;
                this.this$1.currentSession = null;
                this.this$1.SessionRepositoryFilter.this.sessionRepository.delete(this.getId());
            }

            public void setNew(boolean isNew) {
                this.old = !isNew;
            }

            public boolean isNew() {
                this.checkState();
                return !this.old;
            }

            private void checkState() {
                if (this.invalidated) {
                    throw new IllegalStateException("The HttpSession has already be invalidated.");
                }
            }
        }
    }

    private final class SessionRepositoryResponseWrapper
    extends OnCommittedResponseWrapper {
        private final SessionRepositoryRequestWrapper request;

        public SessionRepositoryResponseWrapper(SessionRepositoryRequestWrapper request, HttpServletResponse response) {
            super(response);
            Assert.notNull((Object)((Object)request), (String)"SessionRepositoryRequestWrapper cannot be null");
            this.request = request;
        }

        @Override
        protected void onResponseCommitted() {
            this.request.commitSession();
        }
    }
}

