/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.ExpiringSession;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;

final class RedisSessionExpirationPolicy {
    private static final Log logger = LogFactory.getLog(RedisOperationsSessionRepository.class);
    static final String EXPIRATION_BOUNDED_HASH_KEY_PREFIX = "spring:session:expirations:";
    private final RedisOperations<String, ExpiringSession> sessionRedisOperations;
    private final RedisOperations<String, String> expirationRedisOperations;

    public RedisSessionExpirationPolicy(RedisOperations<String, ExpiringSession> sessionRedisOperations, RedisOperations<String, String> expirationRedisOperations) {
        this.sessionRedisOperations = sessionRedisOperations;
        this.expirationRedisOperations = expirationRedisOperations;
    }

    public void onDelete(ExpiringSession session) {
        long lastAccessedTime = session.getLastAccessedTime();
        int maxInactiveInterval = session.getMaxInactiveInterval();
        long toExpire = this.roundUpToNextMinute(lastAccessedTime, maxInactiveInterval);
        String expireKey = this.getExpirationKey(toExpire);
        this.expirationRedisOperations.boundSetOps((Object)expireKey).remove(new Object[]{session.getId()});
    }

    public void onExpirationUpdated(Long originalExpirationTime, ExpiringSession session) {
        if (originalExpirationTime != null) {
            String expireKey = this.getExpirationKey(originalExpirationTime);
            this.expirationRedisOperations.boundSetOps((Object)expireKey).remove(new Object[]{session.getId()});
        }
        long toExpire = this.roundUpToNextMinute(session.getLastAccessedTime(), session.getMaxInactiveInterval());
        String expireKey = this.getExpirationKey(toExpire);
        this.expirationRedisOperations.boundSetOps((Object)expireKey).add((Object[])new String[]{session.getId()});
        long redisExpirationInSeconds = session.getMaxInactiveInterval();
        String sessionKey = this.getSessionKey(session.getId());
        this.expirationRedisOperations.boundSetOps((Object)expireKey).expire(redisExpirationInSeconds, TimeUnit.SECONDS);
        this.sessionRedisOperations.boundHashOps((Object)sessionKey).expire(redisExpirationInSeconds, TimeUnit.SECONDS);
    }

    private String getExpirationKey(long expires) {
        return EXPIRATION_BOUNDED_HASH_KEY_PREFIX + expires;
    }

    private String getSessionKey(String sessionId) {
        return "spring:session:sessions:" + sessionId;
    }

    public void cleanExpiredSessions() {
        long now = System.currentTimeMillis();
        long prevMin = this.roundDownMinute(now);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up sessions expiring at " + new Date(prevMin)));
        }
        String expirationKey = this.getExpirationKey(prevMin);
        Set sessionsToExpire = this.expirationRedisOperations.boundSetOps((Object)expirationKey).members();
        HashSet<String> keysToDelete = new HashSet<String>(sessionsToExpire.size() + 1);
        keysToDelete.add(expirationKey);
        for (String session : sessionsToExpire) {
            String sessionKey = this.getSessionKey(session);
            keysToDelete.add(sessionKey);
        }
        this.sessionRedisOperations.delete(keysToDelete);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The following expired Sessions were deleted " + keysToDelete));
        }
    }

    private long roundUpToNextMinute(long timeInMs, int inactiveIntervalInSec) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs + TimeUnit.SECONDS.toMillis(inactiveIntervalInSec));
        date.add(12, 1);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }

    private long roundDownMinute(long timeInMs) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs);
        date.add(12, -1);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }
}

