/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.util.Assert;

public class SessionMessageListener
implements MessageListener {
    private static final Log logger = LogFactory.getLog(SessionMessageListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public SessionMessageListener(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] messageBody = message.getBody();
        if (messageBody == null) {
            return;
        }
        String body = new String(messageBody);
        if (!"del".equals(body) && !"expired".equals(body)) {
            return;
        }
        String channel = new String(message.getChannel());
        int beginIndex = channel.lastIndexOf(":") + 1;
        int endIndex = channel.length();
        String sessionId = channel.substring(beginIndex, endIndex);
        this.publishEvent(new SessionDestroyedEvent(this, sessionId));
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error((Object)("Error publishing " + event + "."), ex);
        }
    }
}

