/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.socket.handler;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.web.socket.events.SessionConnectEvent;
import org.springframework.session.web.socket.server.SessionRepositoryMessageInterceptor;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

public final class WebSocketRegistryListener
implements ApplicationListener<ApplicationEvent> {
    private static final Log logger = LogFactory.getLog(WebSocketRegistryListener.class);
    static final CloseStatus SESSION_EXPIRED_STATUS = new CloseStatus(CloseStatus.POLICY_VIOLATION.getCode(), "This connection was established under an authenticated HTTP Session that has expired");
    private final ConcurrentHashMap<String, Map<String, WebSocketSession>> httpSessionIdToWsSessions = new ConcurrentHashMap();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SessionDestroyedEvent) {
            SessionDestroyedEvent e = (SessionDestroyedEvent)event;
            this.closeWsSessions(e.getSessionId());
        } else if (event instanceof SessionConnectEvent) {
            SessionConnectEvent e = (SessionConnectEvent)event;
            this.afterConnectionEstablished(e.getWebSocketSession());
        } else if (event instanceof SessionDisconnectEvent) {
            SessionDisconnectEvent e = (SessionDisconnectEvent)event;
            Map sessionAttributes = SimpMessageHeaderAccessor.getSessionAttributes((Map)e.getMessage().getHeaders());
            String httpSessionId = sessionAttributes == null ? null : SessionRepositoryMessageInterceptor.getSessionId(sessionAttributes);
            this.afterConnectionClosed(httpSessionId, e.getSessionId());
        }
    }

    private void afterConnectionEstablished(WebSocketSession wsSession) {
        Principal principal = wsSession.getPrincipal();
        if (principal == null) {
            return;
        }
        String id = this.getHttpSessionId(wsSession);
        this.registerWsSession(id, wsSession);
    }

    private String getHttpSessionId(WebSocketSession wsSession) {
        Map attributes = wsSession.getAttributes();
        return SessionRepositoryMessageInterceptor.getSessionId(attributes);
    }

    private void afterConnectionClosed(String httpSessionId, String wsSessionId) {
        Map<String, WebSocketSession> sessions = this.httpSessionIdToWsSessions.get(httpSessionId);
        if (sessions != null) {
            boolean result;
            boolean bl = result = sessions.remove(wsSessionId) != null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removal of " + wsSessionId + " was " + result));
            }
        }
    }

    private void registerWsSession(String sessionId, WebSocketSession wsSession) {
        Map<String, WebSocketSession> sessions = this.httpSessionIdToWsSessions.get(sessionId);
        if (sessions == null) {
            sessions = new ConcurrentHashMap<String, WebSocketSession>();
            this.httpSessionIdToWsSessions.putIfAbsent(sessionId, sessions);
            sessions = this.httpSessionIdToWsSessions.get(sessionId);
        }
        sessions.put(wsSession.getId(), wsSession);
    }

    private void closeWsSessions(String sessionId) {
        Map<String, WebSocketSession> sessionsToClose = this.httpSessionIdToWsSessions.remove(sessionId);
        if (sessionsToClose == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing WebSocket connections associated to expired HTTP Session " + sessionId));
        }
        for (WebSocketSession toClose : sessionsToClose.values()) {
            try {
                toClose.close(SESSION_EXPIRED_STATUS);
            }
            catch (IOException e) {
                logger.debug((Object)"Failed to close WebSocketSession (this is nothing to worry about but for debugging only)", (Throwable)e);
            }
        }
    }
}

