/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.MapListener;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.SessionEntryListener;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class HazelcastHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private static final String DO_NOT_CONFIGURE_INACTIVE_INTERVAL_STRING = "";
    private ClassLoader beanClassLoader;
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String sessionMapName = "spring:session:sessions";
    private String sessionListenerUid;
    private IMap<String, ExpiringSession> sessionsMap;

    @Bean
    public SessionRepository<ExpiringSession> sessionRepository(HazelcastInstance hazelcastInstance, SessionEntryListener sessionListener) {
        this.configureSessionMap(hazelcastInstance);
        this.sessionsMap = hazelcastInstance.getMap(this.sessionMapName);
        this.sessionListenerUid = this.sessionsMap.addEntryListener((MapListener)sessionListener, true);
        MapSessionRepository sessionRepository = new MapSessionRepository((Map<String, ExpiringSession>)this.sessionsMap);
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        return sessionRepository;
    }

    @PreDestroy
    private void removeSessionListener() {
        this.sessionsMap.removeEntryListener(this.sessionListenerUid);
    }

    @Bean
    public SessionEntryListener sessionListener(ApplicationEventPublisher eventPublisher) {
        return new SessionEntryListener(eventPublisher);
    }

    private void configureSessionMap(HazelcastInstance hazelcastInstance) {
        MapConfig sessionMapConfig = hazelcastInstance.getConfig().getMapConfig(this.sessionMapName);
        if (this.maxInactiveIntervalInSeconds != null) {
            sessionMapConfig.setMaxIdleSeconds(this.maxInactiveIntervalInSeconds.intValue());
        } else {
            this.maxInactiveIntervalInSeconds = sessionMapConfig.getMaxIdleSeconds();
        }
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.transferAnnotationAttributes(enableAttrs);
    }

    private void transferAnnotationAttributes(AnnotationAttributes enableAttrs) {
        String maxInactiveIntervalString = enableAttrs.getString("maxInactiveIntervalInSeconds");
        if (DO_NOT_CONFIGURE_INACTIVE_INTERVAL_STRING.equals(maxInactiveIntervalString)) {
            this.maxInactiveIntervalInSeconds = null;
        } else {
            try {
                this.maxInactiveIntervalInSeconds = Integer.parseInt(maxInactiveIntervalString);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("@EnableHazelcastHttpSession's maxInactiveIntervalInSeconds expects an int format String but was '" + maxInactiveIntervalString + "' instead.", nfe);
            }
        }
        this.setSessionMapName(enableAttrs.getString("sessionMapName"));
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

