/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.session.ExpiringSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.ExpiringSessionHttpSession;
import org.springframework.session.web.http.HttpSessionStrategy;
import org.springframework.session.web.http.MultiHttpSessionStrategy;
import org.springframework.session.web.http.OnCommittedResponseWrapper;
import org.springframework.session.web.http.OncePerRequestFilter;
import org.springframework.session.web.http.SessionRepositoryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=-2147483598)
public class SessionRepositoryFilter<S extends ExpiringSession>
extends OncePerRequestFilter {
    private static final String SESSION_LOGGER_NAME = SessionRepositoryFilter.class.getName().concat(".SESSION_LOGGER");
    private static final Log SESSION_LOGGER = LogFactory.getLog((String)SESSION_LOGGER_NAME);
    public static final String SESSION_REPOSITORY_ATTR = SessionRepository.class.getName();
    public static final int DEFAULT_ORDER = -2147483598;
    private final SessionRepository<S> sessionRepository;
    private ServletContext servletContext;
    private MultiHttpSessionStrategy httpSessionStrategy = new CookieHttpSessionStrategy();

    public SessionRepositoryFilter(SessionRepository<S> sessionRepository) {
        if (sessionRepository == null) {
            throw new IllegalArgumentException("sessionRepository cannot be null");
        }
        this.sessionRepository = sessionRepository;
    }

    public void setHttpSessionStrategy(HttpSessionStrategy httpSessionStrategy) {
        if (httpSessionStrategy == null) {
            throw new IllegalArgumentException("httpSessionStrategy cannot be null");
        }
        this.httpSessionStrategy = new MultiHttpSessionStrategyAdapter(httpSessionStrategy);
    }

    public void setHttpSessionStrategy(MultiHttpSessionStrategy httpSessionStrategy) {
        if (httpSessionStrategy == null) {
            throw new IllegalArgumentException("httpSessionStrategy cannot be null");
        }
        this.httpSessionStrategy = httpSessionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        request.setAttribute(SESSION_REPOSITORY_ATTR, this.sessionRepository);
        SessionRepositoryRequestWrapper wrappedRequest = new SessionRepositoryRequestWrapper(request, response, this.servletContext);
        SessionRepositoryResponseWrapper wrappedResponse = new SessionRepositoryResponseWrapper(wrappedRequest, response);
        HttpServletRequest strategyRequest = this.httpSessionStrategy.wrapRequest((HttpServletRequest)wrappedRequest, (HttpServletResponse)wrappedResponse);
        HttpServletResponse strategyResponse = this.httpSessionStrategy.wrapResponse((HttpServletRequest)wrappedRequest, (HttpServletResponse)wrappedResponse);
        try {
            filterChain.doFilter((ServletRequest)strategyRequest, (ServletResponse)strategyResponse);
        }
        finally {
            wrappedRequest.commitSession();
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    static class MultiHttpSessionStrategyAdapter
    implements MultiHttpSessionStrategy {
        private HttpSessionStrategy delegate;

        public MultiHttpSessionStrategyAdapter(HttpSessionStrategy delegate) {
            this.delegate = delegate;
        }

        public String getRequestedSessionId(HttpServletRequest request) {
            return this.delegate.getRequestedSessionId(request);
        }

        public void onNewSession(Session session, HttpServletRequest request, HttpServletResponse response) {
            this.delegate.onNewSession(session, request, response);
        }

        public void onInvalidateSession(HttpServletRequest request, HttpServletResponse response) {
            this.delegate.onInvalidateSession(request, response);
        }

        public HttpServletRequest wrapRequest(HttpServletRequest request, HttpServletResponse response) {
            return request;
        }

        public HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response) {
            return response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SessionRepositoryRequestWrapper
    extends HttpServletRequestWrapper {
        private final String CURRENT_SESSION_ATTR;
        private Boolean requestedSessionIdValid;
        private boolean requestedSessionInvalidated;
        private final HttpServletResponse response;
        private final ServletContext servletContext;

        private SessionRepositoryRequestWrapper(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
            super(request);
            this.CURRENT_SESSION_ATTR = HttpServletRequestWrapper.class.getName();
            this.response = response;
            this.servletContext = servletContext;
        }

        private void commitSession() {
            HttpSessionWrapper wrappedSession = this.getCurrentSession();
            if (wrappedSession == null) {
                if (this.isInvalidateClientSession()) {
                    SessionRepositoryFilter.this.httpSessionStrategy.onInvalidateSession((HttpServletRequest)this, this.response);
                }
            } else {
                Object session = wrappedSession.getSession();
                SessionRepositoryFilter.this.sessionRepository.save(session);
                if (!this.isRequestedSessionIdValid() || !session.getId().equals(this.getRequestedSessionId())) {
                    SessionRepositoryFilter.this.httpSessionStrategy.onNewSession((Session)session, (HttpServletRequest)this, this.response);
                }
            }
        }

        private org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getCurrentSession() {
            return (HttpSessionWrapper)this.getAttribute(this.CURRENT_SESSION_ATTR);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void setCurrentSession(HttpSessionWrapper currentSession) {
            if (currentSession == null) {
                this.removeAttribute(this.CURRENT_SESSION_ATTR);
            } else {
                this.setAttribute(this.CURRENT_SESSION_ATTR, currentSession);
            }
        }

        public String changeSessionId() {
            HttpSession session = this.getSession(false);
            if (session == null) {
                throw new IllegalStateException("Cannot change session ID. There is no session associated with this request.");
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            Enumeration iAttrNames = session.getAttributeNames();
            while (iAttrNames.hasMoreElements()) {
                String attrName = (String)iAttrNames.nextElement();
                Object value = session.getAttribute(attrName);
                attrs.put(attrName, value);
            }
            SessionRepositoryFilter.this.sessionRepository.delete(session.getId());
            HttpSessionWrapper original = this.getCurrentSession();
            this.setCurrentSession(null);
            HttpSession newSession = this.getSession();
            original.setSession(newSession.getSession());
            newSession.setMaxInactiveInterval(session.getMaxInactiveInterval());
            for (Map.Entry attr : attrs.entrySet()) {
                String attrName = (String)attr.getKey();
                Object attrValue = attr.getValue();
                newSession.setAttribute(attrName, attrValue);
            }
            return newSession.getId();
        }

        public boolean isRequestedSessionIdValid() {
            if (this.requestedSessionIdValid == null) {
                String sessionId = this.getRequestedSessionId();
                Object session = sessionId == null ? null : (Object)this.getSession(sessionId);
                return this.isRequestedSessionIdValid(session);
            }
            return this.requestedSessionIdValid;
        }

        private boolean isRequestedSessionIdValid(S session) {
            if (this.requestedSessionIdValid == null) {
                this.requestedSessionIdValid = session != null;
            }
            return this.requestedSessionIdValid;
        }

        private boolean isInvalidateClientSession() {
            return this.getCurrentSession() == null && this.requestedSessionInvalidated;
        }

        private S getSession(String sessionId) {
            ExpiringSession session = (ExpiringSession)SessionRepositoryFilter.this.sessionRepository.getSession(sessionId);
            if (session == null) {
                return null;
            }
            session.setLastAccessedTime(System.currentTimeMillis());
            return session;
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession(boolean create) {
            Object session;
            HttpSessionWrapper currentSession = this.getCurrentSession();
            if (currentSession != null) {
                return currentSession;
            }
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId != null && (session = this.getSession(requestedSessionId)) != null) {
                this.requestedSessionIdValid = true;
                currentSession = new HttpSessionWrapper(this, (ExpiringSession)session, this.getServletContext());
                currentSession.setNew(false);
                this.setCurrentSession(currentSession);
                return currentSession;
            }
            if (!create) {
                return null;
            }
            if (SESSION_LOGGER.isDebugEnabled()) {
                SESSION_LOGGER.debug((Object)("A new session was created. To help you troubleshoot where the session was created we provided a StackTrace (this is not an error). You can prevent this from appearing by disabling DEBUG logging for " + SESSION_LOGGER_NAME), (Throwable)new RuntimeException("For debugging purposes only (not an error)"));
            }
            session = (ExpiringSession)SessionRepositoryFilter.this.sessionRepository.createSession();
            session.setLastAccessedTime(System.currentTimeMillis());
            currentSession = new HttpSessionWrapper(this, (ExpiringSession)session, this.getServletContext());
            this.setCurrentSession(currentSession);
            return currentSession;
        }

        public ServletContext getServletContext() {
            if (this.servletContext != null) {
                return this.servletContext;
            }
            return super.getServletContext();
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession() {
            return this.getSession(true);
        }

        public String getRequestedSessionId() {
            return SessionRepositoryFilter.this.httpSessionStrategy.getRequestedSessionId((HttpServletRequest)this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class HttpSessionWrapper
        extends ExpiringSessionHttpSession<S> {
            final /* synthetic */ SessionRepositoryRequestWrapper this$1;

            public HttpSessionWrapper(S session, ServletContext servletContext) {
                this.this$1 = var1_1;
                super(session, servletContext);
            }

            @Override
            public void invalidate() {
                super.invalidate();
                this.this$1.requestedSessionInvalidated = true;
                this.this$1.setCurrentSession(null);
                this.this$1.SessionRepositoryFilter.this.sessionRepository.delete(this.getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SessionRepositoryResponseWrapper
    extends OnCommittedResponseWrapper {
        private final SessionRepositoryRequestWrapper request;

        public SessionRepositoryResponseWrapper(SessionRepositoryRequestWrapper request, HttpServletResponse response) {
            super(response);
            if (request == null) {
                throw new IllegalArgumentException("request cannot be null");
            }
            this.request = request;
        }

        @Override
        protected void onResponseCommitted() {
            this.request.commitSession();
        }
    }
}

