/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.io.IOException;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.boot.TerminalCustomizer;
import org.springframework.shell.jline.ExtendedDefaultParser;
import org.springframework.shell.jline.PromptProvider;

@AutoConfiguration
public class JLineShellAutoConfiguration {
    @Bean(destroyMethod="close")
    public Terminal terminal(ObjectProvider<TerminalCustomizer> customizers) {
        try {
            TerminalBuilder builder = TerminalBuilder.builder();
            builder.systemOutput(TerminalBuilder.SystemOutput.SysOut);
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        }
        catch (IOException e) {
            throw new BeanCreationException("Could not create Terminal", (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={PromptProvider.class})
    public PromptProvider promptProvider() {
        return () -> new AttributedString((CharSequence)"shell:>", AttributedStyle.DEFAULT.foreground(3));
    }

    @Bean
    public Parser parser() {
        ExtendedDefaultParser parser = new ExtendedDefaultParser();
        parser.setEofOnUnclosedQuote(true);
        parser.setEofOnEscapedNewLine(true);
        return parser;
    }
}

