/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.legacy;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ParameterDescription;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.ValueResult;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Component
public class LegacyParameterResolver
implements ParameterResolver {
    private static final String CLI_OPTION_NULL = "__NULL__";
    private static final String CLI_PREFIX = "--";
    @Autowired(required=false)
    private Collection<Converter<?>> converters = new ArrayList();
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public boolean supports(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(CliOption.class);
    }

    public ValueResult resolve(MethodParameter methodParameter, List<String> words) {
        Optional<Converter<?>> converter = this.findOptionalConverter(methodParameter);
        CliOption cliOption = (CliOption)methodParameter.getParameterAnnotation(CliOption.class);
        Map<String, ParseResult> values = this.parseOptions(words);
        Map<String, ValueResult> seenValues = this.convertValues(values, methodParameter, converter);
        switch (seenValues.size()) {
            case 0: {
                if (!cliOption.mandatory()) {
                    String value = cliOption.unspecifiedDefaultValue();
                    Object resolvedValue = converter.orElseThrow(this.noConverterFound(cliOption.key()[0], value, methodParameter.getParameterType())).convertFromText(value, methodParameter.getParameterType(), cliOption.optionContext());
                    return new ValueResult(methodParameter, resolvedValue);
                }
                throw new IllegalArgumentException("Could not find parameter values for " + this.prettifyKeys(Arrays.asList(cliOption.key())) + " in " + words);
            }
            case 1: {
                return seenValues.values().iterator().next();
            }
        }
        throw new RuntimeException("Option has been set multiple times via " + this.prettifyKeys(seenValues.keySet()));
    }

    private Optional<Converter<?>> findOptionalConverter(MethodParameter methodParameter) {
        CliOption cliOption = (CliOption)methodParameter.getParameterAnnotation(CliOption.class);
        return this.converters.stream().filter(c -> c.supports(methodParameter.getParameterType(), cliOption.optionContext())).findFirst();
    }

    public Stream<ParameterDescription> describe(MethodParameter parameter) {
        boolean containsEmptyKey;
        Parameter jlrParameter = parameter.getMethod().getParameters()[parameter.getParameterIndex()];
        CliOption option = jlrParameter.getAnnotation(CliOption.class);
        ParameterDescription result = ParameterDescription.outOf((MethodParameter)parameter);
        result.help(option.help());
        List<String> keys = Arrays.asList(option.key());
        result.keys(this.notDefaultCommandKeys(parameter));
        if (!option.mandatory()) {
            result.defaultValue(CLI_OPTION_NULL.equals(option.unspecifiedDefaultValue()) ? "null" : option.unspecifiedDefaultValue());
        }
        if (!CLI_OPTION_NULL.equals(option.specifiedDefaultValue())) {
            result.whenFlag(option.specifiedDefaultValue());
        }
        result.mandatoryKey(!(containsEmptyKey = keys.contains("")));
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(parameter.getDeclaringClass()).getConstraintsForMethod(parameter.getMethod().getName(), (Class[])parameter.getMethod().getParameterTypes());
        if (constraintsForMethod != null) {
            ParameterDescriptor constraintsDescriptor = (ParameterDescriptor)constraintsForMethod.getParameterDescriptors().get(parameter.getParameterIndex());
            result.elementDescriptor((ElementDescriptor)constraintsDescriptor);
        }
        return Stream.of(result);
    }

    private List<String> notDefaultCommandKeys(MethodParameter parameter) {
        Parameter jlrParameter = parameter.getMethod().getParameters()[parameter.getParameterIndex()];
        CliOption option = jlrParameter.getAnnotation(CliOption.class);
        return Arrays.stream(option.key()).filter(key -> !key.isEmpty()).map(key -> CLI_PREFIX + key).collect(Collectors.toList());
    }

    public List<CompletionProposal> complete(MethodParameter parameter, CompletionContext context) {
        String nextToLast = null;
        if (context.getWords().size() >= 2) {
            nextToLast = (String)context.getWords().get(context.getWords().size() - 2);
        }
        String last = context.getWords().size() >= 1 ? (String)context.getWords().get(context.getWords().size() - 1) : null;
        List<String> commandKeys = this.notDefaultCommandKeys(parameter);
        if (nextToLast != null) {
            if (commandKeys.contains(nextToLast)) {
                if (this.findOptionalConverter(parameter).isPresent()) {
                    ArrayList legacyProposals = new ArrayList();
                    this.findOptionalConverter(parameter).get().getAllPossibleValues(legacyProposals, parameter.getParameterType(), last, ((CliOption)parameter.getParameterAnnotation(CliOption.class)).optionContext(), this.craftMethodTarget());
                    return legacyProposals.stream().filter(lp -> lp.getValue().startsWith(last)).map(this::toCompletionProposal).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }
            if (nextToLast.startsWith(CLI_PREFIX)) {
                return Collections.emptyList();
            }
        }
        if (last != null) {
            return commandKeys.stream().filter(k -> k.startsWith(last)).map(CompletionProposal::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private CompletionProposal toCompletionProposal(Completion c) {
        return new CompletionProposal(c.getValue()).displayText(c.getFormattedValue()).category(c.getHeading());
    }

    private MethodTarget craftMethodTarget() {
        return new MethodTarget(ReflectionUtils.findMethod(Object.class, (String)"toString"), (Object)"foo");
    }

    private Map<String, ParseResult> parseOptions(List<String> words) {
        HashMap<String, ParseResult> values = new HashMap<String, ParseResult>();
        for (int i = 0; i < words.size(); ++i) {
            int from = i;
            String word = words.get(i);
            if (word.startsWith(CLI_PREFIX)) {
                String key = word.substring(CLI_PREFIX.length());
                String value = i < words.size() - 1 && !words.get(i + 1).startsWith(CLI_PREFIX) ? words.get(++i) : null;
                Assert.isTrue((!values.containsKey(key) ? 1 : 0) != 0, (String)String.format("Option %s%s has already been set", CLI_PREFIX, key));
                values.put(key, new ParseResult(value, from));
                continue;
            }
            Assert.isTrue((!values.containsKey("") ? 1 : 0) != 0, (String)"Anonymous option has already been set");
            values.put("", new ParseResult(word, from));
        }
        return values;
    }

    private Map<String, ValueResult> convertValues(Map<String, ParseResult> values, MethodParameter methodParameter, Optional<Converter<?>> converter) {
        HashMap<String, ValueResult> seenValues = new HashMap<String, ValueResult>();
        CliOption option = (CliOption)methodParameter.getParameterAnnotation(CliOption.class);
        for (String key : option.key()) {
            if (!values.containsKey(key)) continue;
            ParseResult parseResult = values.get(key);
            String value = parseResult.value;
            if (value == null && !CLI_OPTION_NULL.equals(option.specifiedDefaultValue())) {
                value = option.specifiedDefaultValue();
            }
            Class parameterType = methodParameter.getParameterType();
            Object resolvedValue = converter.orElseThrow(this.noConverterFound(key, value, parameterType)).convertFromText(value, parameterType, option.optionContext());
            int from = parseResult.from;
            int to = key.isEmpty() || parseResult.value == null ? from : from + 1;
            BitSet wordsUsed = new BitSet();
            wordsUsed.set(from, to + 1);
            BitSet wordsUsedForValues = new BitSet();
            if (parseResult.value != null) {
                wordsUsedForValues.set(to);
            }
            seenValues.put(key, new ValueResult(methodParameter, resolvedValue, wordsUsed, wordsUsedForValues));
        }
        return seenValues;
    }

    private String prettifyKeys(Collection<String> keys) {
        return keys.stream().map(s -> "".equals(s) ? "<anonymous>" : CLI_PREFIX + s).collect(Collectors.joining(", ", "[", "]"));
    }

    private Supplier<IllegalStateException> noConverterFound(String key, String value, Class<?> parameterType) {
        return () -> new IllegalStateException("No converter found for --" + key + " from '" + value + "' to type " + parameterType);
    }

    private static class ParseResult {
        private final String value;
        private final Integer from;

        public ParseResult(String value, Integer from) {
            this.value = value;
            this.from = from;
        }
    }
}

