/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.shell.SimpleShellCommandLineOptions;
import org.springframework.shell.converters.AvailableCommandsConverter;
import org.springframework.shell.converters.BigDecimalConverter;
import org.springframework.shell.converters.BigIntegerConverter;
import org.springframework.shell.converters.BooleanConverter;
import org.springframework.shell.converters.CharacterConverter;
import org.springframework.shell.converters.DateConverter;
import org.springframework.shell.converters.DoubleConverter;
import org.springframework.shell.converters.EnumConverter;
import org.springframework.shell.converters.FloatConverter;
import org.springframework.shell.converters.IntegerConverter;
import org.springframework.shell.converters.LocaleConverter;
import org.springframework.shell.converters.LongConverter;
import org.springframework.shell.converters.ShortConverter;
import org.springframework.shell.converters.SimpleFileConverter;
import org.springframework.shell.converters.StaticFieldConverterImpl;
import org.springframework.shell.converters.StringConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineShellComponent;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.util.StopWatch;

public class Bootstrap {
    private static Bootstrap bootstrap;
    private JLineShellComponent shell;
    private ConfigurableApplicationContext ctx;
    private static StopWatch sw;
    private static SimpleShellCommandLineOptions options;

    public static void main(String[] args) throws IOException {
        ExitShellRequest exitShellRequest;
        sw.start();
        options = SimpleShellCommandLineOptions.parseCommandLine(args);
        for (Map.Entry<String, String> entry : Bootstrap.options.extraSystemProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        try {
            bootstrap = new Bootstrap(null);
            exitShellRequest = bootstrap.run(Bootstrap.options.executeThenQuit);
        }
        catch (RuntimeException t) {
            throw t;
        }
        finally {
            HandlerUtils.flushAllHandlers(Logger.getLogger(""));
        }
        System.exit(exitShellRequest.getExitCode());
    }

    public Bootstrap(String applicationContextLocation) throws IOException {
        this.createApplicationContext();
        this.shell = (JLineShellComponent)this.ctx.getBean("shell", JLineShellComponent.class);
        this.shell.setApplicationContext((ApplicationContext)this.ctx);
        this.shell.setHistorySize(Bootstrap.options.historySize);
        if (Bootstrap.options.executeThenQuit != null) {
            this.shell.setPrintBanner(false);
        }
        Map commands = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.ctx, CommandMarker.class);
        for (CommandMarker command : commands.values()) {
            this.shell.getSimpleParser().add(command);
        }
        Map converters = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.ctx, Converter.class);
        for (Converter converter : converters.values()) {
            this.shell.getSimpleParser().add(converter);
        }
    }

    private void createApplicationContext() {
        AnnotationConfigApplicationContext annctx = new AnnotationConfigApplicationContext();
        this.createAndRegisterBeanDefinition(annctx, StringConverter.class);
        this.createAndRegisterBeanDefinition(annctx, AvailableCommandsConverter.class);
        this.createAndRegisterBeanDefinition(annctx, BigDecimalConverter.class);
        this.createAndRegisterBeanDefinition(annctx, BigIntegerConverter.class);
        this.createAndRegisterBeanDefinition(annctx, BooleanConverter.class);
        this.createAndRegisterBeanDefinition(annctx, CharacterConverter.class);
        this.createAndRegisterBeanDefinition(annctx, DateConverter.class);
        this.createAndRegisterBeanDefinition(annctx, DoubleConverter.class);
        this.createAndRegisterBeanDefinition(annctx, EnumConverter.class);
        this.createAndRegisterBeanDefinition(annctx, FloatConverter.class);
        this.createAndRegisterBeanDefinition(annctx, IntegerConverter.class);
        this.createAndRegisterBeanDefinition(annctx, LocaleConverter.class);
        this.createAndRegisterBeanDefinition(annctx, LongConverter.class);
        this.createAndRegisterBeanDefinition(annctx, ShortConverter.class);
        this.createAndRegisterBeanDefinition(annctx, StaticFieldConverterImpl.class);
        this.createAndRegisterBeanDefinition(annctx, JLineShellComponent.class, "shell");
        this.createAndRegisterBeanDefinition(annctx, SimpleFileConverter.class);
        annctx.scan(new String[]{"org.springframework.shell.commands"});
        annctx.scan(new String[]{"org.springframework.shell.converters"});
        annctx.scan(new String[]{"org.springframework.shell.plugin.support"});
        annctx.refresh();
        this.ctx = this.initPluginApplicationContext(annctx);
        this.ctx.refresh();
    }

    private ConfigurableApplicationContext initPluginApplicationContext(AnnotationConfigApplicationContext annctx) {
        return new ClassPathXmlApplicationContext(new String[]{"classpath*:/META-INF/spring/spring-shell-plugin.xml"}, true, (ApplicationContext)annctx);
    }

    protected void createAndRegisterBeanDefinition(AnnotationConfigApplicationContext annctx, Class clazz) {
        this.createAndRegisterBeanDefinition(annctx, clazz, null);
    }

    protected void createAndRegisterBeanDefinition(AnnotationConfigApplicationContext annctx, Class clazz, String name) {
        RootBeanDefinition rbd = new RootBeanDefinition();
        rbd.setBeanClass(clazz);
        if (name != null) {
            annctx.registerBeanDefinition(name, (BeanDefinition)rbd);
        } else {
            annctx.registerBeanDefinition(clazz.getSimpleName(), (BeanDefinition)rbd);
        }
    }

    private void setupLogging() {
        Logger rootLogger = Logger.getLogger("");
        HandlerUtils.wrapWithDeferredLogHandler(rootLogger, Level.SEVERE);
        Logger sfwLogger = Logger.getLogger("org.springframework");
        sfwLogger.setLevel(Level.WARNING);
        Logger rooLogger = Logger.getLogger("org.springframework.shell");
        rooLogger.setLevel(Level.FINE);
    }

    protected ExitShellRequest run(String[] executeThenQuit) {
        ExitShellRequest exitShellRequest;
        if (null != executeThenQuit) {
            String cmd;
            boolean successful = false;
            exitShellRequest = ExitShellRequest.FATAL_EXIT;
            String[] arr$ = executeThenQuit;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (successful = this.shell.executeCommand(cmd = arr$[i$])); ++i$) {
            }
            if (successful) {
                exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            }
        } else {
            this.shell.start();
            this.shell.promptLoop();
            exitShellRequest = this.shell.getExitShellRequest();
            if (exitShellRequest == null) {
                exitShellRequest = ExitShellRequest.NORMAL_EXIT;
            }
            this.shell.waitForComplete();
        }
        this.ctx.close();
        sw.stop();
        if (this.shell.isDevelopmentMode()) {
            System.out.println("Total execution time: " + sw.getLastTaskTimeMillis() + " ms");
        }
        return exitShellRequest;
    }

    static {
        sw = new StopWatch("Spring Shell");
    }
}

