/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.EventInvitee;
import org.springframework.social.facebook.api.EventOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.Invitation;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.EventInviteeList;
import org.springframework.social.facebook.api.impl.EventList;
import org.springframework.social.facebook.api.impl.InvitationList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventTemplate
extends AbstractFacebookOperations
implements EventOperations {
    private final GraphApi graphApi;

    public EventTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public List<Invitation> getInvitations() {
        this.requireAuthorization();
        return this.getInvitations("me");
    }

    @Override
    public List<Invitation> getInvitations(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "events", InvitationList.class, new String[0]).getList();
    }

    @Override
    public Event getEvent(String eventId) {
        return this.graphApi.fetchObject(eventId, Event.class);
    }

    @Override
    public byte[] getEventImage(String eventId) {
        return this.getEventImage(eventId, ImageType.NORMAL);
    }

    @Override
    public byte[] getEventImage(String eventId, ImageType imageType) {
        return this.graphApi.fetchImage(eventId, "picture", imageType);
    }

    @Override
    public String createEvent(String name, String startTime, String endTime) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"name", (Object)name);
        data.set((Object)"start_time", (Object)startTime);
        data.set((Object)"end_time", (Object)endTime);
        return this.graphApi.publish("me", "events", (MultiValueMap<String, Object>)data);
    }

    @Override
    public void deleteEvent(String eventId) {
        this.requireAuthorization();
        this.graphApi.delete(eventId);
    }

    @Override
    public List<EventInvitee> getInvited(String eventId) {
        return this.graphApi.fetchConnections(eventId, "invited", EventInviteeList.class, new String[0]).getList();
    }

    @Override
    public List<EventInvitee> getAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "attending", EventInviteeList.class, new String[0]).getList();
    }

    @Override
    public List<EventInvitee> getMaybeAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "maybe", EventInviteeList.class, new String[0]).getList();
    }

    @Override
    public List<EventInvitee> getNoReplies(String eventId) {
        return this.graphApi.fetchConnections(eventId, "noreply", EventInviteeList.class, new String[0]).getList();
    }

    @Override
    public List<EventInvitee> getDeclined(String eventId) {
        return this.graphApi.fetchConnections(eventId, "declined", EventInviteeList.class, new String[0]).getList();
    }

    @Override
    public void acceptInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "attending", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void maybeInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "maybe", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void declineInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "declined", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public List<Event> search(String query) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"event");
        return this.graphApi.fetchObject("search", EventList.class, (MultiValueMap<String, String>)queryMap).getList();
    }
}

