/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.FacebookLink;
import org.springframework.social.facebook.api.FeedOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.LinkPost;
import org.springframework.social.facebook.api.NotePost;
import org.springframework.social.facebook.api.Post;
import org.springframework.social.facebook.api.StatusPost;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.LinkPostList;
import org.springframework.social.facebook.api.impl.NotePostList;
import org.springframework.social.facebook.api.impl.PostList;
import org.springframework.social.facebook.api.impl.StatusPostList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeedTemplate
extends AbstractFacebookOperations
implements FeedOperations {
    private final GraphApi graphApi;

    public FeedTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public List<Post> getFeed() {
        return this.getFeed("me");
    }

    @Override
    public List<Post> getFeed(String ownerId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(ownerId, "feed", PostList.class, new String[0]).getList();
    }

    @Override
    public List<Post> getHomeFeed() {
        this.requireAuthorization();
        return this.graphApi.fetchConnections("me", "home", PostList.class, new String[0]).getList();
    }

    @Override
    public List<StatusPost> getStatuses() {
        return this.getStatuses("me");
    }

    @Override
    public List<StatusPost> getStatuses(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "statuses", StatusPostList.class, new String[0]).getList();
    }

    @Override
    public List<LinkPost> getLinks() {
        return this.getLinks("me");
    }

    @Override
    public List<LinkPost> getLinks(String ownerId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(ownerId, "links", LinkPostList.class, new String[0]).getList();
    }

    @Override
    public List<NotePost> getNotes() {
        return this.getNotes("me");
    }

    @Override
    public List<NotePost> getNotes(String ownerId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(ownerId, "notes", NotePostList.class, new String[0]).getList();
    }

    @Override
    public List<Post> getPosts() {
        return this.getPosts("me");
    }

    @Override
    public List<Post> getPosts(String ownerId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(ownerId, "posts", PostList.class, new String[0]).getList();
    }

    @Override
    public Post getFeedEntry(String entryId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(entryId, Post.class);
    }

    @Override
    public String updateStatus(String message) {
        return this.post("me", message);
    }

    @Override
    public String postLink(String message, FacebookLink link) {
        return this.postLink("me", message, link);
    }

    @Override
    public String postLink(String ownerId, String message, FacebookLink link) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"link", (Object)link.getLink());
        map.set((Object)"name", (Object)link.getName());
        map.set((Object)"caption", (Object)link.getCaption());
        map.set((Object)"description", (Object)link.getDescription());
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public String post(String ownerId, String message) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(ownerId, "feed", (MultiValueMap<String, Object>)map);
    }

    @Override
    public void deleteFeedEntry(String id) {
        this.requireAuthorization();
        this.graphApi.delete(id);
    }

    @Override
    public List<Post> searchPublicFeed(String query) {
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        queryParameters.add((Object)"q", (Object)query);
        queryParameters.add((Object)"type", (Object)"post");
        return this.graphApi.fetchObject("search", PostList.class, (MultiValueMap<String, String>)queryParameters).getList();
    }

    @Override
    public List<Post> searchHomeFeed(String query) {
        this.requireAuthorization();
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        queryParameters.add((Object)"q", (Object)query);
        return this.graphApi.fetchConnections("me", "home", PostList.class, (MultiValueMap<String, String>)queryParameters).getList();
    }

    @Override
    public List<Post> searchUserFeed(String query) {
        this.requireAuthorization();
        return this.searchUserFeed("me", query);
    }

    @Override
    public List<Post> searchUserFeed(String userId, String query) {
        this.requireAuthorization();
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        queryParameters.add((Object)"q", (Object)query);
        return this.graphApi.fetchConnections(userId, "feed", PostList.class, (MultiValueMap<String, String>)queryParameters).getList();
    }
}

