/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.FacebookProfile;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Group;
import org.springframework.social.facebook.api.GroupMemberReference;
import org.springframework.social.facebook.api.GroupOperations;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.FacebookProfileList;
import org.springframework.social.facebook.api.impl.GroupList;
import org.springframework.social.facebook.api.impl.GroupMemberReferenceList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupTemplate
extends AbstractFacebookOperations
implements GroupOperations {
    private final GraphApi graphApi;
    private static final String[] FULL_PROFILE_FIELDS = new String[]{"id", "username", "name", "first_name", "last_name", "gender", "locale", "education", "work", "email", "third_party_id", "link", "timezone", "updated_time", "verified", "about", "bio", "birthday", "location", "hometown", "interested_in", "religion", "political", "quotes", "relationship_status", "significant_other", "website"};

    public GroupTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public Group getGroup(String groupId) {
        return this.graphApi.fetchObject(groupId, Group.class);
    }

    @Override
    public byte[] getGroupImage(String groupId) {
        return this.getGroupImage(groupId, ImageType.NORMAL);
    }

    @Override
    public byte[] getGroupImage(String groupId, ImageType imageType) {
        return this.graphApi.fetchImage(groupId, "picture", imageType);
    }

    @Override
    public List<GroupMemberReference> getMembers(String groupId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(groupId, "members", GroupMemberReferenceList.class, new String[0]).getList();
    }

    @Override
    public List<FacebookProfile> getMemberProfiles(String groupId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(groupId, "members", FacebookProfileList.class, FULL_PROFILE_FIELDS).getList();
    }

    @Override
    public List<Group> search(String query) {
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"group");
        queryMap.add((Object)"fields", (Object)"owner,name,description,privacy,icon,updated_time,email,version");
        return this.graphApi.fetchObject("search", GroupList.class, (MultiValueMap<String, String>)queryMap).getList();
    }
}

