/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.FacebookProfile;
import org.springframework.social.facebook.api.FriendOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendTemplate
extends AbstractFacebookOperations
implements FriendOperations {
    private final GraphApi graphApi;
    private final RestTemplate restTemplate;
    private static final String FULL_PROFILE_FIELDS = "id,username,name,first_name,last_name,gender,locale,education,work,email,third_party_id,link,timezone,updated_time,verified,about,bio,birthday,location,hometown,interested_in,religion,political,quotes,relationship_status,significant_other,website";

    public FriendTemplate(GraphApi graphApi, RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Reference> getFriendLists() {
        return this.getFriendLists("me");
    }

    @Override
    public List<Reference> getFriendLists(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friendlists", Reference.class, new String[0]);
    }

    @Override
    public Reference getFriendList(String friendListId) {
        this.requireAuthorization();
        return this.graphApi.fetchObject(friendListId, Reference.class);
    }

    @Override
    public List<Reference> getFriendListMembers(String friendListId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(friendListId, "members", Reference.class, new String[0]);
    }

    @Override
    public String createFriendList(String name) {
        return this.createFriendList("me", name);
    }

    @Override
    public String createFriendList(String userId, String name) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"name", (Object)name);
        return this.graphApi.publish(userId, "friendlists", (MultiValueMap<String, Object>)request);
    }

    @Override
    public void deleteFriendList(String friendListId) {
        this.requireAuthorization();
        this.graphApi.delete(friendListId);
    }

    @Override
    public void addToFriendList(String friendListId, String friendId) {
        this.requireAuthorization();
        this.graphApi.post(friendListId, "members/" + friendId, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void removeFromFriendList(String friendListId, String friendId) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + friendListId + "/members/" + friendId)).build();
        this.restTemplate.delete(uri);
    }

    @Override
    public List<Reference> getFriends() {
        return this.getFriends("me");
    }

    @Override
    public List<String> getFriendIds() {
        return this.getFriendIds("me");
    }

    @Override
    public List<FacebookProfile> getFriendProfiles() {
        return this.getFriendProfiles("me");
    }

    @Override
    public List<FacebookProfile> getFriendProfiles(int offset, int limit) {
        return this.getFriendProfiles("me", offset, limit);
    }

    @Override
    public List<Reference> getFriends(String userId) {
        this.requireAuthorization();
        return this.graphApi.fetchConnections(userId, "friends", Reference.class, new String[0]);
    }

    @Override
    public List<String> getFriendIds(String userId) {
        this.requireAuthorization();
        URI uri = URIBuilder.fromUri((String)("https://graph.facebook.com/" + userId + "/friends")).queryParam("fields", "id").build();
        Map response = (Map)this.restTemplate.getForObject(uri, Map.class);
        List entryList = (List)response.get("data");
        ArrayList<String> idList = new ArrayList<String>(entryList.size());
        for (Map entry : entryList) {
            idList.add((String)entry.get("id"));
        }
        return idList;
    }

    @Override
    public List<FacebookProfile> getFriendProfiles(String userId) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"fields", (Object)FULL_PROFILE_FIELDS);
        return this.graphApi.fetchConnections(userId, "friends", FacebookProfile.class, (MultiValueMap<String, String>)parameters);
    }

    @Override
    public List<FacebookProfile> getFriendProfiles(String userId, int offset, int limit) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"offset", (Object)String.valueOf(offset));
        parameters.set((Object)"limit", (Object)String.valueOf(limit));
        parameters.set((Object)"fields", (Object)FULL_PROFILE_FIELDS);
        return this.graphApi.fetchConnections(userId, "friends", FacebookProfile.class, (MultiValueMap<String, String>)parameters);
    }
}

