/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.TestUser;
import org.springframework.social.facebook.api.TestUserOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class TestUserTemplate
extends AbstractFacebookOperations
implements TestUserOperations {
    private String appId;
    private RestTemplate restTemplate;

    public TestUserTemplate(RestTemplate restTemplate, String appId) {
        super(false);
        this.restTemplate = restTemplate;
        this.appId = appId;
    }

    public TestUser createTestUser(boolean installed, String permissions) {
        return this.createTestUser(installed, permissions, null);
    }

    public TestUser createTestUser(boolean installed, String permissions, String name) {
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"installed", (Object)("" + installed));
        if (name != null) {
            request.set((Object)"name", (Object)name);
        }
        if (permissions != null) {
            request.set((Object)"permissions", (Object)permissions);
        }
        return (TestUser)this.restTemplate.postForObject("https://graph.facebook.com/v2.3/{appId}/accounts/test-users", (Object)request, TestUser.class, new Object[]{this.appId});
    }

    public void sendConfirmFriends(TestUser testUser1, TestUser testUser2) {
        RestOperations userRest = new FacebookTemplate(testUser1.getAccessToken()).restOperations();
        userRest.postForObject("https://graph.facebook.com/v2.3/{testUserId1}/friends/{testUserId2}", (Object)"", String.class, new Object[]{testUser1.getId(), testUser2.getId()});
    }

    public void deleteTestUser(String testUserId) {
        this.restTemplate.delete("https://graph.facebook.com/v2.3/{testUserId}", new Object[]{testUserId});
    }
}

