/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.FqlException;
import org.springframework.social.facebook.api.FqlResultMapper;

public class FqlResult {
    private final Map<String, Object> resultMap;

    public FqlResult(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    public String getString(String fieldName) {
        return this.hasValue(fieldName) ? String.valueOf(this.resultMap.get(fieldName)) : null;
    }

    public Integer getInteger(String fieldName) {
        try {
            return this.hasValue(fieldName) ? Integer.valueOf(String.valueOf(this.resultMap.get(fieldName))) : null;
        }
        catch (NumberFormatException e) {
            throw new FqlException("Field '" + fieldName + "' is not a number.", e);
        }
    }

    public Long getLong(String fieldName) {
        try {
            return this.hasValue(fieldName) ? Long.valueOf(String.valueOf(this.resultMap.get(fieldName))) : null;
        }
        catch (NumberFormatException e) {
            throw new FqlException("Field '" + fieldName + "' is not a number.", e);
        }
    }

    public Float getFloat(String fieldName) {
        try {
            return this.hasValue(fieldName) ? Float.valueOf(String.valueOf(this.resultMap.get(fieldName))) : null;
        }
        catch (NumberFormatException e) {
            throw new FqlException("Field '" + fieldName + "' is not a number.", e);
        }
    }

    public Boolean getBoolean(String fieldName) {
        return this.hasValue(fieldName) ? Boolean.valueOf(String.valueOf(this.resultMap.get(fieldName))) : null;
    }

    public Date getTime(String fieldName) {
        try {
            if (this.hasValue(fieldName)) {
                return new Date(Long.valueOf(String.valueOf(this.resultMap.get(fieldName))) * 1000L);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new FqlException("Field '" + fieldName + "' is not a time.", e);
        }
    }

    public Object getObject(String fieldName) {
        return this.resultMap.get(fieldName);
    }

    public <T> T getObject(String fieldName, FqlResultMapper<T> mapper) {
        if (!this.hasValue(fieldName)) {
            return null;
        }
        try {
            Map value = (Map)this.resultMap.get(fieldName);
            return mapper.mapObject(new FqlResult(value));
        }
        catch (ClassCastException e) {
            throw new FqlException("Field '" + fieldName + "' is not an object.", e);
        }
    }

    public <T> List<T> getList(String fieldName, FqlResultMapper<T> mapper) {
        if (!this.hasValue(fieldName)) {
            return null;
        }
        try {
            ArrayList<T> response = new ArrayList<T>();
            List arrayItems = (List)this.resultMap.get(fieldName);
            for (Map arrayItem : arrayItems) {
                response.add(mapper.mapObject(new FqlResult(arrayItem)));
            }
            return response;
        }
        catch (ClassCastException e) {
            throw new FqlException("Field '" + fieldName + "' is not a list.", e);
        }
    }

    public boolean hasField(String fieldName) {
        return this.resultMap.containsKey(fieldName);
    }

    public boolean hasValue(String fieldName) {
        return this.resultMap.containsKey(fieldName) && this.resultMap.get(fieldName) != null;
    }
}

