/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api;

import org.springframework.social.facebook.api.Post;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class PostData {
    private final String targetFeedId;
    private String message;
    private String linkUrl;
    private String name;
    private String caption;
    private String description;
    private String[] tags;
    private String placeId;
    private String picture;
    private Post.Privacy privacy;
    private String[] allow;
    private String[] deny;

    public PostData(String targetFeedId) {
        this.targetFeedId = targetFeedId;
    }

    public String getTargetFeedId() {
        return this.targetFeedId;
    }

    public PostData message(String message) {
        this.message = message;
        return this;
    }

    public PostData link(String linkUrl, String picture, String name, String caption, String description) {
        this.linkUrl = linkUrl;
        this.picture = picture;
        this.name = name;
        this.caption = caption;
        this.description = description;
        return this;
    }

    public PostData place(String placeId) {
        this.placeId = placeId;
        return this;
    }

    public PostData tags(String ... tags) {
        this.tags = tags;
        return this;
    }

    public PostData privacy(Post.Privacy privacy) {
        this.privacy = privacy;
        return this;
    }

    public PostData allow(String ... allow) {
        this.allow = allow;
        return this;
    }

    public PostData deny(String ... deny) {
        this.deny = deny;
        return this;
    }

    public MultiValueMap<String, Object> toRequestParameters() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (this.message != null) {
            parameters.add((Object)"message", (Object)this.message);
        }
        if (this.linkUrl != null) {
            parameters.add((Object)"link", (Object)this.linkUrl);
        }
        if (this.name != null) {
            parameters.add((Object)"name", (Object)this.name);
        }
        if (this.caption != null) {
            parameters.add((Object)"caption", (Object)this.caption);
        }
        if (this.description != null) {
            parameters.add((Object)"description", (Object)this.description);
        }
        if (this.picture != null) {
            parameters.add((Object)"picture", (Object)this.picture);
        }
        if (this.placeId != null) {
            parameters.add((Object)"place", (Object)this.placeId);
            if (this.tags != null) {
                parameters.add((Object)"tags", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.tags));
            }
        }
        return parameters;
    }
}

