/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api;

import java.util.HashMap;
import java.util.Map;
import org.springframework.social.facebook.api.Post;
import org.springframework.util.StringUtils;

public class Targeting {
    private Post.PrivacyType privacyType = Post.PrivacyType.CUSTOM;
    private String[] countries;
    private String[] locales;
    private String[] regions;
    private String[] cities;
    private Map<String, String> attributesMap = new HashMap<String, String>();

    public Targeting privacyType(Post.PrivacyType privacyType) {
        this.privacyType = privacyType;
        return this;
    }

    public Targeting countries(String ... countries) {
        this.countries = countries;
        return this;
    }

    public Targeting locales(String[] locales) {
        this.locales = locales;
        return this;
    }

    public Targeting regions(String[] regions) {
        this.regions = regions;
        return this;
    }

    public Targeting cities(String[] cities) {
        this.cities = cities;
        return this;
    }

    public Targeting addAttributes(String attributeName, String attributeValue) {
        this.attributesMap.put(attributeName, attributeValue);
        return this;
    }

    public String toString() {
        StringBuffer privacyBuffer = new StringBuffer();
        privacyBuffer.append("{'value': '").append((Object)this.privacyType).append("'");
        if (this.privacyType == Post.PrivacyType.CUSTOM) {
            if (this.countries != null) {
                privacyBuffer.append(",'countries':'").append(StringUtils.arrayToCommaDelimitedString((Object[])this.countries)).append("'");
            }
            if (this.locales != null) {
                privacyBuffer.append(",'locales':'").append(StringUtils.arrayToCommaDelimitedString((Object[])this.locales)).append("'");
            }
            if (this.regions != null) {
                privacyBuffer.append(",'regions':'").append(StringUtils.arrayToCommaDelimitedString((Object[])this.regions)).append("'");
            }
            if (this.cities != null) {
                privacyBuffer.append(",'cities':'").append(StringUtils.arrayToCommaDelimitedString((Object[])this.cities)).append("'");
            }
        }
        if (!this.attributesMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.attributesMap.entrySet()) {
                privacyBuffer.append(",'" + entry.getKey() + "':'" + entry.getValue() + "'");
            }
        }
        privacyBuffer.append("}");
        return privacyBuffer.toString();
    }
}

