/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.api.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.springframework.social.github.api.GitHubApi;
import org.springframework.social.github.api.GitHubUserProfile;
import org.springframework.social.oauth2.ProtectedResourceClientFactory;
import org.springframework.web.client.RestTemplate;

public class GitHubTemplate
implements GitHubApi {
    private final RestTemplate restTemplate;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z", Locale.ENGLISH);
    static final String PROFILE_URL = "https://github.com/api/v2/json/user/show";

    public GitHubTemplate(String accessToken) {
        this.restTemplate = ProtectedResourceClientFactory.draft8((String)accessToken);
    }

    public String getProfileId() {
        return this.getUserProfile().getUsername();
    }

    public GitHubUserProfile getUserProfile() {
        Map result = (Map)this.restTemplate.getForObject(PROFILE_URL, Map.class, new Object[0]);
        Map user = (Map)result.get("user");
        Long gitHubId = Long.valueOf(String.valueOf(user.get("id")));
        String username = String.valueOf(user.get("login"));
        String name = String.valueOf(user.get("name"));
        String location = user.get("location") != null ? String.valueOf(user.get("location")) : null;
        String company = user.get("company") != null ? String.valueOf(user.get("company")) : null;
        String blog = user.get("blog") != null ? String.valueOf(user.get("blog")) : null;
        String email = user.get("email") != null ? String.valueOf(user.get("email")) : null;
        Date createdDate = this.toDate(String.valueOf(user.get("created_at")), this.dateFormat);
        String gravatarId = (String)user.get("gravatar_id");
        String profileImageUrl = gravatarId != null ? "https://secure.gravatar.com/avatar/" + gravatarId : null;
        return new GitHubUserProfile(gitHubId, username, name, location, company, blog, email, profileImageUrl, createdDate);
    }

    public String getProfileUrl() {
        return "https://github.com/" + this.getProfileId();
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

