/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.api.impl;

import java.util.Arrays;
import java.util.List;
import org.springframework.social.github.api.GistOperations;
import org.springframework.social.github.api.GitHubComment;
import org.springframework.social.github.api.GitHubGist;
import org.springframework.social.github.api.impl.AbstractGitHubOperations;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GistTemplate
extends AbstractGitHubOperations
implements GistOperations {
    private final RestTemplate restTemplate;

    public GistTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<GitHubGist> getUserGists(String user) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUri("users/{user}/gists"), GitHubGist[].class, new Object[]{user}));
    }

    @Override
    public List<GitHubGist> getGists() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUri("gists"), GitHubGist[].class, new Object[0]));
    }

    @Override
    public List<GitHubGist> getPublicGists() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUri("gists/public"), GitHubGist[].class, new Object[0]));
    }

    @Override
    public List<GitHubGist> getStarredGists() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUri("gists/starred"), GitHubGist[].class, new Object[0]));
    }

    @Override
    public GitHubGist getGist(String id) {
        return (GitHubGist)this.restTemplate.getForObject(this.buildUri("gists/{id}"), GitHubGist.class, new Object[]{id});
    }

    @Override
    public List<GitHubComment> getGistComments(String id) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.buildUri("gists/{id}/comments"), GitHubComment[].class, new Object[]{id}));
    }

    @Override
    public GitHubComment getGistComment(Long id) {
        return (GitHubComment)this.restTemplate.getForObject(this.buildUri("gists/comments/{id}"), GitHubComment.class, new Object[]{id});
    }
}

