/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.config.xml;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.xml.AbstractProviderConfigBeanDefinitionParser;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.github.api.GitHub;
import org.springframework.social.github.api.impl.GitHubTemplate;
import org.springframework.social.github.connect.GitHubConnectionFactory;
import org.springframework.social.github.security.GitHubAuthenticationService;
import org.springframework.social.security.provider.SocialAuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitHubConfigBeanDefinitionParser
extends AbstractProviderConfigBeanDefinitionParser {
    public GitHubConfigBeanDefinitionParser() {
        super(GitHubConnectionFactory.class, GitHubApiHelper.class);
    }

    protected Class<? extends SocialAuthenticationService<?>> getAuthenticationServiceClass() {
        return GitHubAuthenticationService.class;
    }

    protected BeanDefinition getConnectionFactoryBeanDefinition(String appId, String appSecret, Map<String, Object> allAttributes) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GitHubConnectionFactory.class).addConstructorArgValue((Object)appId).addConstructorArgValue((Object)appSecret);
        return builder.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GitHubApiHelper
    implements ApiHelper<GitHub> {
        private final UsersConnectionRepository usersConnectionRepository;
        private final UserIdSource userIdSource;
        private static final Log logger = LogFactory.getLog(GitHubApiHelper.class);

        private GitHubApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
            this.usersConnectionRepository = usersConnectionRepository;
            this.userIdSource = userIdSource;
        }

        public GitHub getApi() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Getting API binding instance for GitHub");
            }
            Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(GitHub.class);
            if (logger.isDebugEnabled() && connection == null) {
                logger.debug((Object)"No current connection; Returning default GitHubTemplate instance.");
            }
            return connection != null ? (GitHub)connection.getApi() : new GitHubTemplate();
        }
    }
}

