/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.plus.Organization;
import org.springframework.social.google.api.plus.ProfileUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
extends ApiEntity {
    @JsonProperty
    private Name name;
    private String displayName;
    @JsonProperty
    private Image image;
    private String thumbnailUrl;
    private Date birthday;
    private String gender;
    private String aboutMe;
    private String relationshipStatus;
    private List<ProfileUrl> urls;
    private List<Organization> organizations;
    private Map<String, Boolean> placesLived;

    public String toString() {
        return this.displayName;
    }

    @JsonSetter
    private void setPlacesLived(List<PlaceLived> placesLivedAsList) {
        this.placesLived = new LinkedHashMap<String, Boolean>();
        if (placesLivedAsList != null) {
            for (PlaceLived placeLived : placesLivedAsList) {
                this.placesLived.put(placeLived.value, placeLived.primary);
            }
        }
    }

    public String getGivenName() {
        return this.name == null ? null : this.name.givenName;
    }

    public String getFamilyName() {
        return this.name == null ? null : this.name.familyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getImageUrl() {
        if (this.thumbnailUrl != null) {
            return this.thumbnailUrl;
        }
        if (this.image != null) {
            return this.image.url;
        }
        return null;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getGender() {
        return this.gender;
    }

    public String getAboutMe() {
        return this.aboutMe;
    }

    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public List<ProfileUrl> getUrls() {
        return this.urls;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public Map<String, Boolean> getPlacesLived() {
        return this.placesLived;
    }

    private static class PlaceLived {
        @JsonProperty
        private String value;
        @JsonProperty
        private boolean primary;

        private PlaceLived() {
        }
    }

    public static class Image {
        @JsonProperty
        private String url;
    }

    private static class Name {
        @JsonProperty
        private String givenName;
        @JsonProperty
        private String familyName;

        private Name() {
        }
    }
}

