/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus.moments;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.springframework.social.google.api.plus.moments.Moment;
import org.springframework.social.google.api.plus.moments.Rating;

@JsonTypeName(value="http://schemas.google.com/ReviewActivity")
public class ReviewActivity
extends Moment {
    @JsonProperty
    private Result result;

    protected ReviewActivity() {
    }

    public ReviewActivity(String targetUrl, String url, String text) {
        super(targetUrl);
        this.result = new Result();
        this.result.url = url;
        this.result.text = text;
    }

    public ReviewActivity(String targetUrl, String url, String text, String name, Rating reviewRating) {
        this(targetUrl, url, text);
        this.result.name = name;
        this.result.reviewRating = reviewRating;
    }

    @JsonIgnore
    public String getResultUrl() {
        return this.result.url;
    }

    @JsonIgnore
    public String getResultText() {
        return this.result.text;
    }

    @JsonIgnore
    public String getResultName() {
        return this.result.name;
    }

    @JsonIgnore
    public Rating getReviewRating() {
        return this.result.reviewRating;
    }

    protected static class Result {
        @JsonProperty
        String url;
        @JsonProperty
        String text;
        @JsonProperty
        String name;
        @JsonProperty
        Rating reviewRating;

        protected Result() {
        }

        @JsonGetter
        String getType() {
            return "http://schema.org/Review";
        }
    }
}

