/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.tasks.impl;

import java.util.Date;
import org.springframework.social.google.api.query.impl.ApiQueryBuilderImpl;
import org.springframework.social.google.api.tasks.TaskQueryBuilder;
import org.springframework.social.google.api.tasks.TasksPage;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskQueryBuilderImpl
extends ApiQueryBuilderImpl<TaskQueryBuilder, TasksPage>
implements TaskQueryBuilder {
    private String taskListId = "@default";

    TaskQueryBuilderImpl(RestTemplate restTemplate) {
        super(TasksPage.class, restTemplate);
    }

    @Override
    public TaskQueryBuilder fromTaskList(String taskListId) {
        this.taskListId = taskListId;
        return this;
    }

    @Override
    public TaskQueryBuilder completedFrom(Date completedMin) {
        return (TaskQueryBuilder)this.appendQueryParam("completedMin", completedMin);
    }

    @Override
    public TaskQueryBuilder completedUntil(Date completedMax) {
        return (TaskQueryBuilder)this.appendQueryParam("completedMax", completedMax);
    }

    @Override
    public TaskQueryBuilder dueFrom(Date dueMin) {
        return (TaskQueryBuilder)this.appendQueryParam("dueMin", dueMin);
    }

    @Override
    public TaskQueryBuilder dueUntil(Date dueMax) {
        return (TaskQueryBuilder)this.appendQueryParam("dueMax", dueMax);
    }

    @Override
    public TaskQueryBuilder updatedFrom(Date updatedMin) {
        return (TaskQueryBuilder)this.appendQueryParam("updatedMin", updatedMin);
    }

    @Override
    public TaskQueryBuilder includeCompleted(boolean showCompleted) {
        return (TaskQueryBuilder)this.appendQueryParam("showCompleted", showCompleted);
    }

    @Override
    public TaskQueryBuilder includeDeleted(boolean showDeleted) {
        return (TaskQueryBuilder)this.appendQueryParam("showDeleted", showDeleted);
    }

    @Override
    public TaskQueryBuilder includeHidden(boolean showHidden) {
        return (TaskQueryBuilder)this.appendQueryParam("showHidden", showHidden);
    }

    @Override
    protected String build() {
        this.feedUrl = "https://www.googleapis.com/tasks/v1/lists/" + this.taskListId + "/tasks";
        return super.build();
    }
}

