/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.query.impl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.springframework.social.google.api.query.ApiPage;
import org.springframework.social.google.api.query.ApiQueryBuilder;
import org.springframework.social.google.api.query.impl.QueryBuilderImpl;
import org.springframework.web.client.RestTemplate;

public class ApiQueryBuilderImpl<Q extends ApiQueryBuilder<?, T>, T extends ApiPage<?>>
extends QueryBuilderImpl<Q, T>
implements ApiQueryBuilder<Q, T> {
    private final Class<T> type;
    private final RestTemplate restTemplate;

    protected static String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public ApiQueryBuilderImpl(Class<T> type, RestTemplate restTemplate) {
        this.type = type;
        this.restTemplate = restTemplate;
    }

    public ApiQueryBuilderImpl(String feedUrl, Class<T> type, RestTemplate restTemplate) {
        super(feedUrl);
        this.type = type;
        this.restTemplate = restTemplate;
    }

    @Override
    public Q fromPage(String pageToken) {
        return (Q)((ApiQueryBuilder)this.appendQueryParam("pageToken", pageToken));
    }

    @Override
    public T getPage() {
        try {
            return (T)((ApiPage)this.restTemplate.getForObject(new URI(this.build().toString()), this.type));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

