/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.tasks.impl;

import org.springframework.social.google.api.impl.AbstractGoogleApiOperations;
import org.springframework.social.google.api.tasks.Task;
import org.springframework.social.google.api.tasks.TaskList;
import org.springframework.social.google.api.tasks.TaskListQueryBuilder;
import org.springframework.social.google.api.tasks.TaskListsPage;
import org.springframework.social.google.api.tasks.TaskOperations;
import org.springframework.social.google.api.tasks.TaskQueryBuilder;
import org.springframework.social.google.api.tasks.TasksPage;
import org.springframework.social.google.api.tasks.impl.TaskListQueryBuilderImpl;
import org.springframework.social.google.api.tasks.impl.TaskQueryBuilderImpl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TaskTemplate
extends AbstractGoogleApiOperations
implements TaskOperations {
    static final String TASK_LISTS_URL = "https://www.googleapis.com/tasks/v1/users/@me/lists";
    static final String TASKS_URL = "https://www.googleapis.com/tasks/v1/lists/";
    static final String DEFAULT = "@default";
    static final String TASKS = "/tasks";

    public TaskTemplate(RestTemplate restTemplate, boolean isAuthorized) {
        super(restTemplate, isAuthorized);
    }

    @Override
    public TaskListsPage getTaskLists() {
        return (TaskListsPage)((TaskListQueryBuilder)this.taskListQuery().maxResultsNumber(100)).getPage();
    }

    @Override
    public TaskListsPage getTaskLists(String pageToken) {
        return (TaskListsPage)((TaskListQueryBuilder)this.taskListQuery().fromPage(pageToken)).getPage();
    }

    @Override
    public TaskList getTaskList(String id) {
        return this.getEntity("https://www.googleapis.com/tasks/v1/users/@me/lists/" + id, TaskList.class);
    }

    @Override
    public TaskList saveTaskList(TaskList taskList) {
        return this.saveEntity(TASK_LISTS_URL, taskList);
    }

    @Override
    public void deleteTaskList(TaskList taskList) {
        this.deleteTaskList(taskList.getId());
    }

    @Override
    public void deleteTaskList(String taskListId) {
        this.deleteEntity(TASK_LISTS_URL, taskListId);
    }

    @Override
    public TaskListQueryBuilder taskListQuery() {
        return new TaskListQueryBuilderImpl(this.restTemplate);
    }

    @Override
    public TasksPage getTasks() {
        return (TasksPage)((TaskQueryBuilder)this.taskQuery().maxResultsNumber(100)).getPage();
    }

    @Override
    public TasksPage getTasks(String taskListId, String pageToken) {
        return (TasksPage)((TaskQueryBuilder)this.taskQuery().fromTaskList(taskListId).fromPage(pageToken)).getPage();
    }

    @Override
    public Task getTask(String id) {
        return this.getTask(DEFAULT, id);
    }

    @Override
    public Task getTask(String taskListId, String id) {
        return this.getEntity(TASKS_URL + taskListId + TASKS + '/' + id, Task.class);
    }

    @Override
    public Task saveTask(Task task) {
        return this.saveTask(DEFAULT, task);
    }

    @Override
    public Task saveTask(String taskListId, Task task) {
        return this.saveEntity(TASKS_URL + taskListId + TASKS, task);
    }

    @Override
    public Task createTaskAt(String taskListId, String parent, String previous, Task task) {
        Assert.isNull((Object)task.getId());
        StringBuilder sb = new StringBuilder(TASKS_URL).append(TaskTemplate.defaultIfBlank(taskListId, DEFAULT)).append(TASKS).append('?');
        if (StringUtils.hasText((String)parent)) {
            sb.append("parent=").append(parent).append('&');
        }
        if (StringUtils.hasText((String)previous)) {
            sb.append("previous=").append(previous);
        }
        return this.saveEntity(sb.toString(), task);
    }

    @Override
    public Task moveTask(String taskListId, Task task, String parent, String previous) {
        Assert.notNull((Object)task.getId());
        Assert.isTrue((StringUtils.hasText((String)parent) || StringUtils.hasText((String)previous) ? 1 : 0) != 0, (String)"'parent' and/or 'previous' must be set");
        StringBuilder sb = new StringBuilder(TASKS_URL).append(TaskTemplate.defaultIfBlank(taskListId, DEFAULT)).append(TASKS).append('/').append(task.getId()).append("/move?");
        if (StringUtils.hasText((String)parent)) {
            sb.append("parent=").append(parent).append('&');
        }
        if (StringUtils.hasText((String)previous)) {
            sb.append("previous=").append(previous);
        }
        return (Task)this.restTemplate.postForObject(sb.toString(), null, Task.class, new Object[0]);
    }

    @Override
    public void deleteTask(String taskId) {
        this.deleteTask(DEFAULT, taskId);
    }

    @Override
    public void deleteTask(Task task) {
        this.deleteTask(task.getId());
    }

    @Override
    public void deleteTask(String taskListId, String taskId) {
        this.deleteEntity(TASKS_URL + taskListId + TASKS, taskId);
    }

    @Override
    public void deleteTask(String taskListId, Task task) {
        this.deleteTask(taskListId, task.getId());
    }

    @Override
    public TaskQueryBuilder taskQuery() {
        return new TaskQueryBuilderImpl(this.restTemplate);
    }

    private static String defaultIfBlank(String value, String defaultValue) {
        return StringUtils.hasText((String)value) ? value : defaultValue;
    }

    @Override
    public void clearCompletedTasks(TaskList taskList) {
        Assert.notNull((Object)taskList.getId());
        this.restTemplate.postForLocation(TASKS_URL + taskList.getId() + "/clear", null, new Object[0]);
    }
}

