/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.connect;

import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.util.MultiValueMap;

public class GoogleOAuth2Template
extends OAuth2Template {
    public GoogleOAuth2Template(String clientId, String clientSecret) {
        super(clientId, clientSecret, "https://accounts.google.com/o/oauth2/auth", "https://accounts.google.com/o/oauth2/token");
        this.setUseParametersForClientAuthentication(true);
    }

    protected AccessGrant postForAccessGrant(String accessTokenUrl, MultiValueMap<String, String> parameters) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity(parameters, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.getRestTemplate().exchange(accessTokenUrl, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        Map responseMap = (Map)responseEntity.getBody();
        return this.extractAccessGrant(responseMap);
    }

    private AccessGrant extractAccessGrant(Map<String, Object> result) {
        String accessToken = (String)result.get("access_token");
        String scope = (String)result.get("scope");
        String refreshToken = (String)result.get("refresh_token");
        Number expiresInNumber = (Number)result.get("expires_in");
        Long expiresIn = expiresInNumber == null ? null : Long.valueOf(expiresInNumber.longValue());
        return this.createAccessGrant(accessToken, scope, refreshToken, expiresIn, result);
    }
}

