/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.social.linkedin.api.LinkedInProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Post
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedInProfile creator;
    private final String id;
    private final String title;
    private final PostType type;
    private Date creationTimestamp;
    private PostRelation relationToViewer;
    private String summary;
    private List<LinkedInProfile> likes;
    private Attachment attachment;

    public Post(LinkedInProfile creator, String id, String title, PostType type) {
        this.creator = creator;
        this.id = id;
        this.title = title;
        this.type = type;
    }

    public LinkedInProfile getCreator() {
        return this.creator;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public PostType getType() {
        return this.type;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public PostRelation getRelationToViewer() {
        return this.relationToViewer;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<LinkedInProfile> getLikes() {
        return this.likes;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostAvailableAction {
        ADD_COMMENT,
        FLAG_AS_INAPPROPRIATE,
        CATEGORIZE_AS_JOB,
        CATEGORIZE_AS_PROMOTION,
        FOLLOW,
        LIKE,
        REPLY_PRIVATELY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostType {
        STANDARD,
        NEWS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostCategory {
        DISCUSSION,
        JOB;

    }

    public static class Attachment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String contentDomain;
        private final String contentUrl;
        private final String imageUrl;
        private final String summary;
        private final String title;

        public Attachment(String contentDomain, String contentUrl, String imageUrl, String summary, String title) {
            this.contentDomain = contentDomain;
            this.contentUrl = contentUrl;
            this.imageUrl = imageUrl;
            this.summary = summary;
            this.title = title;
        }

        public String getContentDomain() {
            return this.contentDomain;
        }

        public String getContentUrl() {
            return this.contentUrl;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getTitle() {
            return this.title;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostRelation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Boolean isFollowing;
        private final Boolean isLiked;
        private final List<PostAvailableAction> availableActions;

        public PostRelation(List<PostAvailableAction> availableActions, Boolean isFollowing, Boolean isLiked) {
            this.availableActions = availableActions;
            this.isFollowing = isFollowing;
            this.isLiked = isLiked;
        }

        public Boolean isFollowing() {
            return this.isFollowing;
        }

        public Boolean isLiked() {
            return this.isLiked;
        }

        public List<PostAvailableAction> getAvailableActions() {
            return this.availableActions;
        }
    }
}

