/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.social.linkedin.api.CommunicationOperations;
import org.springframework.social.linkedin.api.ConnectionAuthorization;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommunicationTemplate
implements CommunicationOperations {
    private final RestOperations restOperations;
    public static final String MESSAGING_URL = "https://api.linkedin.com/v1/people/~/mailbox";
    public static final String PEOPLE = "/people/";

    public CommunicationTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @Override
    public void sendMessage(String subject, String body, List<String> recipientIds) {
        HashMap<String, Object> mailboxItem = new HashMap<String, Object>();
        mailboxItem.put("recipients", new Recipients(recipientIds));
        mailboxItem.put("subject", subject);
        mailboxItem.put("body", body);
        this.restOperations.postForLocation(MESSAGING_URL, mailboxItem, new Object[0]);
    }

    @Override
    public void sendMessage(String subject, String body, String ... recipientIds) {
        this.sendMessage(subject, body, Arrays.asList(recipientIds));
    }

    @Override
    public void connectTo(String subject, String body, String recipientId, ConnectionAuthorization connectionAuthorization) {
        HashMap<String, Object> mailboxItem = new HashMap<String, Object>();
        mailboxItem.put("recipients", new Recipients(Arrays.asList(recipientId)));
        mailboxItem.put("subject", subject);
        mailboxItem.put("body", body);
        String[] nameValue = connectionAuthorization.getValue().split(":");
        mailboxItem.put("item-content", new ItemContent(nameValue[0], nameValue[1]));
        this.restOperations.postForLocation(MESSAGING_URL, mailboxItem, new Object[0]);
    }

    @Override
    public void connectTo(String subject, String body, String email, String firstName, String lastName) {
        HashMap<String, Object> mailboxItem = new HashMap<String, Object>();
        mailboxItem.put("recipients", new Recipients(email, firstName, lastName));
        mailboxItem.put("subject", subject);
        mailboxItem.put("body", body);
        mailboxItem.put("item-content", new ItemContent());
        this.restOperations.postForLocation(MESSAGING_URL, mailboxItem, new Object[0]);
    }

    private static final class Person {
        private final String _path;
        private final String firstName;
        private final String lastName;

        private Person(String _path) {
            this._path = _path;
            this.firstName = null;
            this.lastName = null;
        }

        private Person(String _path, String firstName, String lastName) {
            this._path = _path;
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String get_path() {
            return this._path;
        }

        @JsonProperty(value="first-name")
        public String getFirstName() {
            return this.firstName;
        }

        @JsonProperty(value="last-name")
        public String getLastName() {
            return this.lastName;
        }
    }

    private static final class Recipient {
        private final Person person;

        private Recipient(String person) {
            this.person = new Person(person);
        }

        private Recipient(String person, String firstName, String lastName) {
            this.person = new Person(person, firstName, lastName);
        }

        public final Person getPerson() {
            return this.person;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Recipients {
        private final List<Recipient> values;

        private Recipients(List<String> recipientIds) {
            this.values = new ArrayList<Recipient>();
            for (String r : recipientIds) {
                this.values.add(new Recipient(CommunicationTemplate.PEOPLE + r));
            }
        }

        private Recipients(String email, String firstName, String lastName) {
            this.values = Collections.singletonList(new Recipient("/people/email=" + email, firstName, lastName));
        }

        private Recipients(String recipientId) {
            this.values = Collections.singletonList(new Recipient(CommunicationTemplate.PEOPLE + recipientId));
        }

        public List<Recipient> getValues() {
            return this.values;
        }
    }

    private static final class Authorization {
        private final String name;
        private final String value;

        private Authorization(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static final class InvitationRequest {
        private final String connectType = "friend";
        private final Authorization authorization;

        private InvitationRequest(String name, String value) {
            this.authorization = new Authorization(name, value);
        }

        private InvitationRequest() {
            this.authorization = null;
        }

        @JsonProperty(value="connect-type")
        public String getConnectType() {
            return "friend";
        }

        public Authorization getAuthorization() {
            return this.authorization;
        }
    }

    private static final class ItemContent {
        private final InvitationRequest invitationRequest;

        private ItemContent(String name, String value) {
            this.invitationRequest = new InvitationRequest(name, value);
        }

        private ItemContent() {
            this.invitationRequest = new InvitationRequest();
        }

        @JsonProperty(value="invitation-request")
        public InvitationRequest getInvitationRequest() {
            return this.invitationRequest;
        }
    }
}

