/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.linkedin.api.CommunicationOperations;
import org.springframework.social.linkedin.api.CompanyOperations;
import org.springframework.social.linkedin.api.ConnectionOperations;
import org.springframework.social.linkedin.api.GroupOperations;
import org.springframework.social.linkedin.api.JobOperations;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.NetworkUpdateOperations;
import org.springframework.social.linkedin.api.ProfileOperations;
import org.springframework.social.linkedin.api.impl.CommunicationTemplate;
import org.springframework.social.linkedin.api.impl.CompanyTemplate;
import org.springframework.social.linkedin.api.impl.ConnectionTemplate;
import org.springframework.social.linkedin.api.impl.GroupTemplate;
import org.springframework.social.linkedin.api.impl.JobTemplate;
import org.springframework.social.linkedin.api.impl.JsonFormatHeaderRequestFactory;
import org.springframework.social.linkedin.api.impl.NetworkUpdateTemplate;
import org.springframework.social.linkedin.api.impl.ProfileTemplate;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;
import org.springframework.social.support.HttpRequestDecorator;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class LinkedInTemplate
extends AbstractOAuth1ApiBinding
implements LinkedIn {
    private NetworkUpdateOperations networkUpdateOperations;
    private ProfileOperations profileOperations;
    private ConnectionOperations connectionOperations;
    private CompanyOperations companyOperations;
    private CommunicationOperations communicationOperations;
    private JobOperations jobOperations;
    private GroupOperations groupOperations;
    private ObjectMapper objectMapper;
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)LinkedInTemplate.class.getClassLoader());
    static final String BASE_URL = "https://api.linkedin.com/v1/people/";

    public LinkedInTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.registerLinkedInJsonModule();
        this.registerJsonFormatInterceptor();
        this.initSubApis();
    }

    public ConnectionOperations connectionOperations() {
        return this.connectionOperations;
    }

    public NetworkUpdateOperations networkUpdateOperations() {
        return this.networkUpdateOperations;
    }

    public ProfileOperations profileOperations() {
        return this.profileOperations;
    }

    public CompanyOperations companyOperations() {
        return this.companyOperations;
    }

    public CommunicationOperations communicationOperations() {
        return this.communicationOperations;
    }

    public JobOperations jobOperations() {
        return this.jobOperations;
    }

    public GroupOperations groupOperations() {
        return this.groupOperations;
    }

    public RestOperations restOperations() {
        return this.getRestTemplate();
    }

    private void registerLinkedInJsonModule() {
        List converters = this.getRestTemplate().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJacksonHttpMessageConverter)) continue;
            MappingJacksonHttpMessageConverter jsonConverter = (MappingJacksonHttpMessageConverter)converter;
            this.objectMapper = new ObjectMapper();
            this.objectMapper.registerModule((Module)new LinkedInModule());
            this.objectMapper.configure(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
            this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL));
            jsonConverter.setObjectMapper(this.objectMapper);
        }
    }

    private void registerJsonFormatInterceptor() {
        RestTemplate restTemplate = this.getRestTemplate();
        if (interceptorsSupported) {
            List interceptors = restTemplate.getInterceptors();
            interceptors.add(new JsonFormatInterceptor());
        } else {
            ClientHttpRequestFactory originalRequestFactory = restTemplate.getRequestFactory();
            JsonFormatHeaderRequestFactory newRequestFactory = new JsonFormatHeaderRequestFactory(originalRequestFactory);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)newRequestFactory);
        }
    }

    private void initSubApis() {
        this.connectionOperations = new ConnectionTemplate((RestOperations)this.getRestTemplate());
        this.networkUpdateOperations = new NetworkUpdateTemplate((RestOperations)this.getRestTemplate());
        this.profileOperations = new ProfileTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.companyOperations = new CompanyTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.communicationOperations = new CommunicationTemplate((RestOperations)this.getRestTemplate());
        this.jobOperations = new JobTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.groupOperations = new GroupTemplate((RestOperations)this.getRestTemplate());
    }

    private static final class JsonFormatInterceptor
    implements ClientHttpRequestInterceptor {
        private JsonFormatInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpRequestDecorator contentTypeResourceRequest = new HttpRequestDecorator(request);
            contentTypeResourceRequest.getHeaders().add("x-li-format", "json");
            return execution.execute((HttpRequest)contentTypeResourceRequest, body);
        }
    }
}

