/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.net.URI;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.LinkedInProfileFull;
import org.springframework.social.linkedin.api.LinkedInProfiles;
import org.springframework.social.linkedin.api.ProfileField;
import org.springframework.social.linkedin.api.ProfileOperations;
import org.springframework.social.linkedin.api.SearchParameters;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.web.client.RestOperations;

class ProfileTemplate
extends AbstractTemplate
implements ProfileOperations {
    private RestOperations restOperations;
    private ObjectMapper objectMapper;
    static final String PROFILE_URL = "https://api.linkedin.com/v1/people/{id}:(id,first-name,last-name,headline,industry,site-standard-profile-request,public-profile-url,picture-url,summary)?format=json";
    static final String PROFILE_URL_FULL;
    static final String PEOPLE_SEARCH_URL = "https://api.linkedin.com/v1/people-search:(people:(id,first-name,last-name,headline,industry,site-standard-profile-request,public-profile-url,picture-url,summary,api-standard-profile-request))?{&keywords}{&first-name}{&last-name}{&company-name}{&current-company}{&title}{&current-title}{&school-name}{&current-school}{&country-code}{&postal-code}{&distance}{&start}{&count}{&sort}";

    public ProfileTemplate(RestOperations restOperations, ObjectMapper objectMapper) {
        this.restOperations = restOperations;
        this.objectMapper = objectMapper;
    }

    public String getProfileId() {
        return this.getUserProfile().getId();
    }

    public String getProfileUrl() {
        return this.getUserProfile().getPublicProfileUrl();
    }

    public LinkedInProfile getUserProfile() {
        return (LinkedInProfile)this.restOperations.getForObject(PROFILE_URL, LinkedInProfile.class, new Object[]{"~"});
    }

    public LinkedInProfileFull getUserProfileFull() {
        return (LinkedInProfileFull)this.restOperations.getForObject(PROFILE_URL_FULL, LinkedInProfileFull.class, new Object[]{"~"});
    }

    public LinkedInProfile getProfileById(String id) {
        return (LinkedInProfile)this.restOperations.getForObject(PROFILE_URL, LinkedInProfile.class, new Object[]{"id=" + id});
    }

    public LinkedInProfile getProfileByPublicUrl(String url) {
        return (LinkedInProfile)this.restOperations.getForObject(PROFILE_URL, LinkedInProfile.class, new Object[]{"url=" + url});
    }

    public LinkedInProfileFull getProfileFullById(String id) {
        return (LinkedInProfileFull)this.restOperations.getForObject(PROFILE_URL_FULL, LinkedInProfileFull.class, new Object[]{"id=" + id});
    }

    public LinkedInProfileFull getProfileFullByPublicUrl(String url) {
        return (LinkedInProfileFull)this.restOperations.getForObject(PROFILE_URL_FULL, LinkedInProfileFull.class, new Object[]{"url=" + url});
    }

    public LinkedInProfiles search(SearchParameters parameters) {
        JsonNode node = (JsonNode)this.restOperations.getForObject(this.expand(PEOPLE_SEARCH_URL, parameters), JsonNode.class);
        try {
            return (LinkedInProfiles)this.objectMapper.readValue(node.path("people"), LinkedInProfiles.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URI expand(String url, SearchParameters parameters) {
        Object[] variables = new Object[]{parameters.getKeywords(), parameters.getFirstName(), parameters.getLastName(), parameters.getCompanyName(), parameters.getCurrentCompany(), parameters.getTitle(), parameters.getCurrentTitle(), parameters.getSchoolName(), parameters.getCurrentSchool(), parameters.getCountryCode(), parameters.getPostalCode(), parameters.getDistance(), parameters.getStart(), parameters.getCount(), parameters.getSort()};
        return this.expand(url, variables, true);
    }

    static {
        StringBuffer b = new StringBuffer();
        b.append("https://api.linkedin.com/v1/people/").append("{id}:(");
        boolean first = true;
        block3: for (ProfileField f : ProfileField.values()) {
            switch (f) {
                case CONNECTIONS: {
                    continue block3;
                }
                default: {
                    if (first) {
                        first = false;
                    } else {
                        b.append(',');
                    }
                    b.append((Object)f);
                }
            }
        }
        b.append(")?format=json");
        PROFILE_URL_FULL = b.toString();
    }
}

