/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.Post;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupCountMixin {
    @JsonCreator
    GroupCountMixin(@JsonProperty(value="category") @JsonDeserialize(using=PostCategoryDeserializer.class) Post.PostCategory category, @JsonProperty(value="count") Integer count) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PostCategoryDeserializer
    extends JsonDeserializer<Post.PostCategory> {
        private PostCategoryDeserializer() {
        }

        public Post.PostCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Post.PostCategory.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }
}

