/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupRelationMixin {
    @JsonCreator
    GroupRelationMixin(@JsonProperty(value="availableActions") @JsonDeserialize(using=AvailableActionDeserializer.class) List<Group.GroupAvailableAction> availableActions, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Group.MembershipState.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AvailableActionDeserializer
    extends JsonDeserializer<List<Group.GroupAvailableAction>> {
        private AvailableActionDeserializer() {
        }

        public List<Group.GroupAvailableAction> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<Group.GroupAvailableAction> actions = new ArrayList<Group.GroupAvailableAction>();
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                for (JsonNode d : dataNode) {
                    String s = d.path("code").getTextValue();
                    if (s == null) continue;
                    actions.add(Group.GroupAvailableAction.valueOf(s.replace('-', '_').toUpperCase()));
                }
            }
            return actions;
        }
    }
}

